<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;


// HEADER STYLE
$this->start_controls_section(
    '_section_style_header',
    [
        'label' => __( 'Header', 'choicy-core' ),
        'tab'   => Controls_Manager::TAB_STYLE,
    ]
);

// ENABLE POSITION ABSOLUTE
$this->add_control(
    'enable_position_absolute',
    [
        'label'        => __( 'Enable Position Absolute', 'choicy-core' ),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __( 'Yes', 'choicy-core' ),
        'label_off'    => __( 'No', 'choicy-core' ),
        'return_value' => 'yes',
    ]
);

// HEADER TOP POSITION
$this->add_responsive_control(
    'header_top_position',
    [
        'label'      => __( 'Header Top Position', 'choicy-core' ),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%'],
        'range'      => [
            'px' => [
                'min' => 0,
                'max' => 200,
            ],
            '%'  => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'selectors'  => [
            '{{WRAPPER}} .tx-header' => 'top: {{SIZE}}{{UNIT}};',
        ],
        'condition'  => [
            'enable_position_absolute' => 'yes',
        ],
    ]
);

// cart icon color
$this->add_control(
    'cart_icon_color',
    [
        'label'     => __( 'Cart Icon Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-cart-btn-2' => 'color: {{VALUE}};',
        ],
    ]
);

// cart count color
$this->add_control(
    'cart_count_color',
    [
        'label'     => __( 'Cart Count Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-cart-btn-2 .number' => 'color: {{VALUE}};',
        ],
    ]
);

// CART COUNT BG
$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name'     => 'cart_count_bg_color',
        'label'    => __( 'Background Color', 'choicy-core' ),
        'types'    => ['classic', 'gradient'],
        'selector' => '
            {{WRAPPER}} .chy-cart-btn-2 .number
        ',
    ]
);

// search icon color
$this->add_control(
    'search_icon_color',
    [
        'label'     => __( 'Search Icon Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-search-btn-1' => 'color: {{VALUE}};',
        ],
    ]
);

// END HEADER STYLE
$this->end_controls_section();
