<?php $rand = rand( 1, 1000 ); ?>
<div class="chy-faq-page-accordion">
    <div class="accordion chy-sd-1-item" id="accordionExample_<?php echo esc_attr($rand); ?>">
        <?php
        foreach ( $settings['faq_lists'] as $id => $list ):
            $is_active = $list['is_active'] == 'yes' ? 'active-block' : '';
            $active = $list['is_active'] == 'yes' ? 'active' : '';
            $show = $list['is_active'] == 'yes' ? 'show' : '';
            $aria_expanded = $list['is_active'] == 'yes' ? 'false' : 'true';
            $collapsed = $list['is_active'] == 'yes' ? 'collapsed' : '';
        ?>
            <div class="accordion-item mb-15" >
                <h2 class="accordion-header <?php echo esc_attr($collapsed); ?>" id="heading-<?php echo esc_attr($rand . '-' . $id); ?>">
                    <button class="accordion-button"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse-<?php echo esc_attr($rand . '-' . $id); ?>"
                    aria-expanded="<?php echo esc_attr($aria_expanded); ?>"
                    aria-controls="collapse-<?php echo esc_attr($rand . '-' . $id); ?>">
                        <span class="icon-2"><i class="flaticon-arrow"></i></span>
                        <span class="title chy-heading-1"><?php echo elh_element_kses_intermediate($list['title']); ?></span>
                        <span class="icon"><i class="far fa-plus"></i></span>
                    </button>
                </h2>
                <div
                id="collapse-<?php echo esc_attr($rand . '-' . $id); ?>"
                class="accordion-collapse collapse <?php echo esc_attr($show); ?>"
                aria-labelledby="heading-<?php echo esc_attr($rand . '-' . $id); ?>"
                data-bs-parent="#accordionExample_<?php echo esc_attr($rand); ?>">
                    <div class="accordion-body ">
                        <div class="disc chy-para-1">
                            <?php echo elh_element_kses_intermediate($list['content']); ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach;?>
    </div>
</div>