<?php

namespace ElementHelper\Widget;

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;

defined( 'ABSPATH' ) || die();

class Tx_Faq extends Element_El_Widget {

    /**
     * Get widget name.
     *
     * Retrieve Choicy Core widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'tx_faq';
    }

    /**
     * Get widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title() {
        return __( 'Choicy Faq', 'choicy-core' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.themexriver.com/widgets/gradient-heading/';
    }

    /**
     * Get widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'elh-widget-icon eicon-t-letter';
    }

    public function get_keywords() {
        return ['btn', 'faq', 'choicy', 'choicy faq'];
    }

    protected function register_content_controls() {

        //Settings
        $this->start_controls_section(
            '_section_settings',
            [
                'label' => __( 'Settings', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'choicy-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'choicy-core' ),
                    'style_2' => __( 'Style 2', 'choicy-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_title',
            [
                'label' => __( 'Lists', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        // is active
        $repeater->add_control(
            'is_active',
            [
                'label'        => __( 'Active', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'choicy-core' ),
                'label_off'    => __( 'No', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );

        // faq title
        $repeater->add_control(
            'title',
            [
                'label'       => __( 'Title', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Faq Title', 'choicy-core' ),
                'label_block' => true,
            ]
        );

        // faq content
        $repeater->add_control(
            'content',
            [
                'label'       => __( 'Content', 'choicy-core' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __( 'Faq Content', 'choicy-core' ),
                'label_block' => true,
            ]
        );

        // faq lists
        $this->add_control(
            'faq_lists',
            [
                'label'       => __( 'Lists', 'choicy-core' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'default'     => [
                    [
                        'title'   => __( 'Faq Title #1', 'choicy-core' ),
                        'content' => __( 'Faq Content #1', 'choicy-core' ),
                    ],
                    [
                        'title'   => __( 'Faq Title #2', 'choicy-core' ),
                        'content' => __( 'Faq Content #2', 'choicy-core' ),
                    ],
                    [
                        'title'   => __( 'Faq Title #3', 'choicy-core' ),
                        'content' => __( 'Faq Content #3', 'choicy-core' ),
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();

    }

    protected function register_style_controls() {

        // faq content style
        $this->start_controls_section(
            '_section_style_faq_content',
            [
                'label' => __( 'Faq Content', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        // faq text color
        $this->add_control(
            'faq_text_color',
            [
                'label'     => __( 'Text Color', 'choicy-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accordion-box .block .content .text' => 'color: {{VALUE}};',
                ],
            ]
        );

        // typography
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'faq_typography',
                'label'    => __( 'Typography', 'choicy-core' ),
                'selector' => '{{WRAPPER}} .accordion-box .block .content .text',
            ]
        );
        $this->add_control(
            'left_icon_heading',
            [
                'label'     => esc_html__( 'Left Icon BG Color', 'Text-domain' ),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        // left icon bg
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => 'faq_left_icon_bg',
                'label'    => __( 'Left Icon Background', 'choicy-core' ),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .chy-sd-1-item .accordion-item .accordion-header .accordion-button .icon-2',
            ]
        );

        // left icon color
        $this->add_control(
            'faq_left_icon_color',
            [
                'label'     => __( 'Left Icon Color', 'choicy-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chy-sd-1-item .accordion-item .accordion-header .accordion-button .icon-2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'right_icon_heading',
            [
                'label'     => esc_html__( 'Right Icon BG Color', 'Text-domain' ),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        // right icon bg
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => 'faq_right_icon_bg',
                'label'    => __( 'Right Icon Background', 'choicy-core' ),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .chy-sd-1-item .accordion-item .accordion-header .accordion-button:is(:not(.collapsed)) .icon',
            ]
        );

        // right icon color
        $this->add_control(
            'faq_right_icon_color',
            [
                'label'     => __( 'Right Icon Color', 'choicy-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chy-sd-1-item .accordion-item .accordion-header .accordion-button:is(:not(.collapsed)) .icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_heading',
            [
                'label'     => esc_html__( 'Title Color', 'Text-domain' ),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        // title color
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => 'title_color',
                'label'    => __( 'Title Color', 'choicy-core' ),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .chy-sd-1-item .accordion-item .accordion-header .accordion-button:is(:not(.collapsed)) .title',
            ]
        );

        // end
        $this->end_controls_section();

    }

    protected function render() {

        $settings = $this->get_settings_for_display();
        $dir = dirname( __FILE__ );

        $style = !empty( $settings['design_style'] ) ? $settings['design_style'] : 'style_1';

        switch ( $style ) {
        case 'style_2':
            include $dir . '/views/view-2.php';
            break;
        default:
            include $dir . '/views/view-1.php';
        }
    }
}
