<?php

    $subtitle_animation = '';
    if($settings['enable_sub_title_anim'] === 'yes') {
        $subtitle_animation = 'wow '.$settings['sub_title_animation'];
    } else {
        $subtitle_animation = '';
    }

    $title_animation = '';
    if($settings['enable_title_anim'] === 'yes') {
        $title_animation = 'chy-split-text '.$settings['title_animation'];
    } else {
        $title_animation = '';
    }

    if( $settings['enable_sub_title_shape'] === 'yes' ) {
        $sub_title_shape = ' isShape';
    } else {
        $sub_title_shape = ' noShape';
    }

?>
<div class="chy-cta-1-area chy-slideinup mt-0">
    <div class="container chy-container-1">
        <div class="chy-cta-1-wrap">
            <?php if(!empty( $settings['bg_image']['url'] )) : ?>
            <img src="<?php echo esc_url($settings['bg_image']['url']); ?>" class="bg-img chy-zoomout2" alt="">
            <?php endif; ?>
            <div class="chy-cta-1-content">
                <div class="section-title-wrap">
                    <?php if(!empty( $settings['sub_title'] )) : ?>
                    <h5 class="chy-subtitle-1 <?php echo esc_attr($subtitle_animation . $sub_title_shape); ?>">
                        <?php echo elh_element_kses_intermediate($settings['sub_title']); ?>
                    </h5>
                    <?php endif; ?>
                    <?php
                        $title = elh_element_kses_basic( $settings['title'] );
                        $this->add_render_attribute( 'title', 'class', 'tx-title chy-title-1 '.esc_attr($title_animation).'' );
                        printf('<%1$s %2$s>%3$s</%1$s>',
                            tag_escape($settings['title_tag']),
                            $this->get_render_attribute_string('title'),
                            $title
                        );
                    ?>
                </div>

                <?php if(!empty( $settings['button_text'] )) : ?>
                <a class="chy-pr-btn-1" href="<?php echo esc_url($settings['button_link']['url']); ?>">
                    <span class="text">
                        <?php echo elh_element_kses_intermediate($settings['button_text']); ?>
                    </span>
                    <?php if(!empty( $settings['button_icon'] )) : ?>
                    <span class="icon">
                        <?php \Elementor\Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    </span>
                    <?php endif; ?>
                </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>