<?php

    $title_animation = '';
    if($settings['enable_title_anim'] === 'yes') {
        $title_animation = 'chy-split-text '.$settings['title_animation'];
    } else {
        $title_animation = '';
    }
?>
<div class="chy-video-1-area img-cover">
    <div class="content-wrap">
        <a aria-label="links" class="chy-plybtn-2 popup-video chy-zoomout2" href="<?php echo esc_url($settings['video_link']['url']); ?>">
            <?php \Elementor\Icons_Manager::render_icon( $settings['video_icon'], [ 'aria-hidden' => 'true' ] ); ?>

            <?php if(!empty( $settings['video_button_image']['url'] )) : ?>
            <img class="text-img" src="<?php echo esc_url($settings['video_button_image']['url']); ?>" alt="">
            <?php endif; ?>
        </a>
        <?php
            $title = elh_element_kses_basic( $settings['title'] );
            $this->add_render_attribute( 'title', 'class', 'tx-title chy-heading-1 title '.esc_attr($title_animation).'' );
            printf('<%1$s %2$s>%3$s</%1$s>',
                tag_escape($settings['title_tag']),
                $this->get_render_attribute_string('title'),
                $title
            );
        ?>
    </div>
    <?php if(!empty( $settings['bg_image']['url'] )) : ?>
    <img class="chy-zoomout2" src="<?php echo esc_url($settings['bg_image']['url']); ?>" alt="">
    <?php endif; ?>
</div>