<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;

// newsletter style
$this->start_controls_section(
    '_section_style_newsletter',
    [
        'label' => __( 'NEWSLETTER STYLE', 'choicy-core' ),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
            'design_style' => 'style_3',
        ],
    ]
);

// newsletter input bg
$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name'     => 'newsletter_input_bg',
        'label'    => __( 'Input Background', 'choicy-core' ),
        'types'    => [ 'classic', 'gradient' ],
        'selector' => '{{WRAPPER}} .chy-cta-5-form input',
    ]
);

// newsletter input border
$this->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name'     => 'newsletter_input_border',
        'label'    => __( 'Input Border', 'choicy-core' ),
        'selector' => '{{WRAPPER}} .chy-cta-5-form input',
    ]
);

// text color
$this->add_control(
    'newsletter_input_text_color',
    [
        'label'     => __( 'Text Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-cta-5-form input' => 'color: {{VALUE}};',
            '{{WRAPPER}} .chy-cta-5-form input::placeholder' => 'color: {{VALUE}};',

        ],
    ]
);

// end
$this->end_controls_section();