<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;

$this->start_controls_section(
    '_section_style_button',
    [
        'label' => __( 'BUTTON STYLE', 'choicy-core' ),
        'tab'   => Controls_Manager::TAB_STYLE,
    ]
);

// typography
$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'     => 'button_typography',
        'label'    => __( 'Typography', 'choicy-core' ),
        'selector' => '
        {{WRAPPER}} .chy-pr-btn-5,
        {{WRAPPER}} .chy-pr-btn-5 .text
        ',
    ]
);

// Border radious
$this->add_responsive_control(
    'button_border_radius',
    [
        'label'      => __( 'Border Radius', 'choicy-core' ),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors'  => [
            '{{WRAPPER}} .chy-pr-btn-5' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

// Group_Control_Border
$this->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name'     => 'button_border',
        'label'    => __( 'Border', 'choicy-core' ),
        'selector' => '{{WRAPPER}} .chy-pr-btn-5',
    ]
);

// padding
$this->add_responsive_control(
    'button_padding',
    [
        'label'      => __( 'Padding', 'choicy-core' ),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', 'em', '%'],
        'selectors'  => [
            '{{WRAPPER}} .chy-pr-btn-5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

// margin
$this->add_responsive_control(
    'button_margin',
    [
        'label'      => __( 'Margin', 'choicy-core' ),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', 'em', '%'],
        'selectors'  => [
            '{{WRAPPER}} .chy-pr-btn-5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->start_controls_tabs( '_tabs_button' );

$this->start_controls_tab(
    '_tab_button_normal',
    [
        'label' => __( 'Normal', 'choicy-core' ),
    ]
);

// color
$this->add_control(
    'button_color',
    [
        'label'     => __( 'Text Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-pr-btn-5'       => 'color: {{VALUE}};',
            '{{WRAPPER}} .chy-pr-btn-5 .text' => 'color: {{VALUE}};',
        ],
    ]
);

// icon color
$this->add_control(
    'button_icon_color',
    [
        'label'     => __( 'Icon Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-pr-btn-5 .icon' => 'color: {{VALUE}};',
        ],
    ]
);

// group control bg color
$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name'     => 'button_bg_color',
        'label'    => __( 'Background Color', 'choicy-core' ),
        'types'    => ['classic', 'gradient'],
        'selector' => '
            {{WRAPPER}} .chy-pr-btn-5
        ',
    ]
);

$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name'     => 'button_after_color',
        'label'    => __( 'Button After Bg', 'choicy-core' ),
        'types'    => ['classic', 'gradient'],
        'selector' => '
            {{WRAPPER}} .chy-pr-btn-5::after
        ',
    ]
);

$this->end_controls_tab();

$this->start_controls_tab(
    '_tab_button_hover',
    [
        'label' => __( 'Hover', 'choicy-core' ),
    ]
);

// color
$this->add_control(
    'button_color_hover',
    [
        'label'     => __( 'Text Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-pr-btn-5:hover'       => 'color: {{VALUE}};',
            '{{WRAPPER}} .chy-pr-btn-5:hover .text' => 'color: {{VALUE}};',
        ],
    ]
);

// icon color
$this->add_control(
    'button_icon_color_hover',
    [
        'label'     => __( 'Icon Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-pr-btn-5:hover .icon' => 'color: {{VALUE}};',
        ],
    ]
);

// background color
$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name'     => 'button_bg_color_hover',
        'label'    => __( 'Background Color', 'choicy-core' ),
        'types'    => ['classic', 'gradient'],
        'selector' => '
         {{WRAPPER}} .chy-pr-btn-5:hover
        ',
    ]
);

$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name'     => 'button_after_bg_color_hover',
        'label'    => __( 'Background Color', 'choicy-core' ),
        'types'    => ['classic', 'gradient'],
        'selector' => '
        {{WRAPPER}} .chy-pr-btn-5:hover::after
        ',
    ]
);

$this->end_controls_tab();

$this->end_controls_tabs();

$this->end_controls_section();