<?php
if($settings['enable_border'] === 'yes') {
    $has_border = 'has-border';
} else {
    $has_border = 'no-border';
}
?>
<div class="border-left <?php echo esc_attr($has_border); ?>">
    <div class="contact-page-contact-list mb-50">
        <?php foreach($settings['contact_info_lists'] as $list) : ?>
        <div class="item">
            <?php if( $list['enable_icon'] == 'yes' ) : ?>
            <div class="icon">
                <?php \Elementor\Icons_Manager::render_icon( $list['info_icon'], [ 'aria-hidden' => 'true' ] ); ?>
            </div>
            <?php endif; ?>
            <div class="content-wrap">
                <?php if(!empty( $list['info_label'] )) : ?>
                <h4 class="chy-heading-1 title"><?php echo elh_element_kses_intermediate($list['info_label']); ?></h4>
                <?php endif; ?>

                <?php echo elh_element_kses_intermediate($list['info_text']); ?>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
    <ul class="contact-page-social-link list-unstyled">
        <?php foreach($settings['social_links'] as $list) : ?>
        <li>
            <a
            href="<?php echo esc_url($list['social_link']['url']); ?>"
            target="<?php echo esc_attr( $list['social_link']['is_external'] ? '_blank' : '_self' ); ?>"
            rel="<?php echo esc_attr( $list['social_link']['nofollow'] ? 'nofollow' : '' ); ?>"
            >
                <?php if( $list['enable_icon'] === 'yes' ) : ?>
                <span class="icon">
                    <?php if( $list['type'] === 'icon' ) : ?>
                        <?php \Elementor\Icons_Manager::render_icon( $list['social_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    <?php else : ?>
                        <img src="<?php echo esc_url( $list['social_image']['url'] ); ?>" alt="<?php echo esc_attr( $list['social_image']['alt'] ); ?>">
                    <?php endif; ?>
                </span>
                <?php endif; ?>
            </a>
        </li>
        <?php endforeach; ?>
    </ul>
</div>