<?php

namespace ElementHelper\Widget;

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;

defined( 'ABSPATH' ) || die();

class Tx_Contact_Info extends Element_El_Widget {

    /**
     * Get widget name.
     *
     * Retrieve Choicy Core widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'tx_contact_info';
    }

    /**
     * Get widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title() {
        return __( 'TX Contact Info', 'choicy-core' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.themexriver.com/widgets/gradient-heading/';
    }

    /**
     * Get widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'elh-widget-icon eicon-t-letter';
    }

    public function get_keywords() {
        return ['btn', 'contact info', 'info', 'info lists'];
    }


    protected function register_content_controls() {

        //Settings
        $this->start_controls_section(
            '_section_design_settings',
            [
                'label' => __( 'DESIGN STYLE', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'choicy-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'choicy-core' ),
                    'style_2' => __( 'Style 2', 'choicy-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        $this->end_controls_section();

        // CONTACT NUMBER
        $this->start_controls_section(
            '_section_contact_info',
            [
                'label' => __( 'Contact Infos', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // repeater
        $repeater = new Repeater();

        // enable icon
        $repeater->add_control(
            'enable_icon',
            [
                'label'        => __( 'Enable Icon', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'choicy-core' ),
                'label_off'    => __( 'No', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // contact info icon
        $repeater->add_control(
            'info_icon',
            [
                'label'       => __( 'Contact Info Icon', 'choicy-core' ),
                'type'        => Controls_Manager::ICONS,
                'default'     => [
                    'value'   => 'fal fa-phone',
                    'library' => 'solid',
                ],
                'label_block' => true,
                'condition'   => [
                    'enable_icon' => 'yes',
                ],
            ]
        );

        // NUMBER
        $repeater->add_control(
            'info_label',
            [
                'label'       => __( 'Contact Info Label', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        // info text
        $repeater->add_control(
            'info_text',
            [
                'label'       => __( 'Contact Info Text', 'choicy-core' ),
                'type'        => Controls_Manager::WYSIWYG,
                'label_block' => true,
            ]
        );

        // add repeater to main
        $this->add_control(
            'contact_info_lists',
            [
                'label'       => __( 'Contact Info Lists', 'choicy-core' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'default'     => [
                    [
                        'info_label' => __( 'Phone Number', 'choicy-core' ),
                        'info_text'  => __( 'Phone Number', 'choicy-core' ),
                    ],
                    [
                        'info_label' => __( 'Email Address', 'choicy-core' ),
                        'info_text'  => __( 'Email Address', 'choicy-core' ),
                    ],
                    [
                        'info_label' => __( 'Office Address', 'choicy-core' ),
                        'info_text'  => __( 'Office Address', 'choicy-core' ),
                    ],
                ],
                'condition'   => [
                    'design_style' => 'style_1',
                ],
                'title_field' => '{{{ info_label }}}',
            ]
        );
        // CONTACT NUMBER
        $this->end_controls_section();

        $this->start_controls_section(
            '_section_contact_number',
            [
                'label'     => __( 'Contact Number', 'choicy-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition'   => [
                    'design_style' => 'style_2',
                ],
            ]
        );

        // enable icon
        $this->add_control(
            'enable_icon',
            [
                'label'        => __( 'Enable Icon', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'choicy-core' ),
                'label_off'    => __( 'No', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // contact info icon
        $this->add_control(
            'contact_info_icon',
            [
                'label'       => __( 'Contact Info Icon', 'choicy-core' ),
                'type'        => Controls_Manager::ICONS,
                'default'     => [
                    'value'   => 'fal fa-phone',
                    'library' => 'solid',
                ],
                'label_block' => true,
                'condition'   => [
                    'enable_icon' => 'yes',
                ],
            ]
        );

        // contact info label
        $this->add_control(
            'contact_info_label',
            [
                'label'       => __( 'Contact Info Label', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Call Us Now', 'choicy-core' ),
                'label_block' => true,
            ]
        );

        // contact info number
        $this->add_control(
            'contact_info_number',
            [
                'label'       => __( 'Contact Info Number', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( '+193-940-9845', 'choicy-core' ),
                'label_block' => true,
            ]
        );

        // END CONTACT NUMBER
        $this->end_controls_section();


        $this->start_controls_section(
            '_section_list_items',
            [
                'label' => __( 'List Items', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition'   => [
                    'design_style' => 'style_1',
                ],
            ]
        );

        $repeater = new \Elementor\Repeater();

        // enable_icon
        $repeater->add_control(
            'enable_icon',
            [
                'label'        => __( 'Enable Icon', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'choicy-core' ),
                'label_off'    => __( 'Hide', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );


        $repeater->add_control(
            'type',
            [
                'label'          => __( 'Social Icon', 'choicy-core' ),
                'type'           => Controls_Manager::CHOOSE,
                'label_block'    => false,
                'options'        => [
                    'icon'  => [
                        'title' => __( 'Icon', 'choicy-core' ),
                        'icon'  => 'far fa-smile',
                    ],
                    'image' => [
                        'title' => __( 'Image', 'choicy-core' ),
                        'icon'  => 'fa fa-image',
                    ],
                ],
                'default'        => 'icon',
                'toggle'         => false,
                'style_transfer' => true,
                'condition'      => [
                    'enable_icon' => 'yes',
                ],
            ]
        );

        // list icon
        $repeater->add_control(
            'social_icon',
            [
                'label'       => __( 'Icon', 'choicy-core' ),
                'type'        => Controls_Manager::ICONS,
                'default'     => [
                    'value'   => 'fas fa-check',
                    'library' => 'solid',
                ],
                'label_block' => true,
                'condition'   => [
                    'type' => 'icon',
                    'enable_icon' => 'yes',
                ],
            ]
        );

        // list image
        $repeater->add_control(
            'social_image',
            [
                'label'       => __( 'Image', 'choicy-core' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
                'condition'   => [
                    'type' => 'image',
                    'enable_icon' => 'yes',
                ],
            ]
        );

        // enable label
        $repeater->add_control(
            'enable_label',
            [
                'label'        => __( 'Enable Label', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'choicy-core' ),
                'label_off'    => __( 'Hide', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // info label
        $repeater->add_control(
            'social_label',
            [
                'label'       => __( 'Social Label', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Social Label', 'choicy-core' ),
                'label_block' => true,
                'condition'   => [
                    'enable_label' => 'yes',
                ],
            ]
        );

        // list_link
        $repeater->add_control(
            'social_link',
            [
                'label'       => __( 'Social Link', 'choicy-core' ),
                'type'        => Controls_Manager::URL,
                'label_block' => true,
                'default'     => [
                    'url' => '#',
                ],
            ]
        );

        $this->add_control(
            'social_links',
            [
                'label'       => __( 'Social Links', 'choicy-core' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
            ]
        );

        $this->end_controls_section();

    }

    protected function register_style_controls() {

        $dir = dirname( __FILE__ );

        $style_files = glob( $dir . '/styles/*.php' );

        if ( $style_files ) {
            foreach ( $style_files as $style_file ) {
                include $style_file;
            }
        }
    }

    protected function render() {

        $settings = $this->get_settings_for_display();
        $dir = dirname( __FILE__ );

        if ( !empty( $settings['design_style'] ) && $settings['design_style'] == 'style_3' ):
            include $dir . '/views/view-3.php';

        elseif ( !empty( $settings['design_style'] ) && $settings['design_style'] == 'style_2' ):
            include $dir . '/views/view-2.php';
        else:
            include $dir . '/views/view-1.php';
        endif;
    }
}
