<?php
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;

// CONTENT STYLE
$this->start_controls_section(
    '_section_style_content',
    [
        'label' => __( 'Content Style', 'choicy-core' ),
        'tab'   => Controls_Manager::TAB_STYLE,
    ]
);

// CONTENT TITLE COLOR
$this->add_control(
    'content_title_color',
    [
        'label'     => __( 'Title Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .contact-page-contact-list .title' => 'color: {{VALUE}};',
        ],
    ]
);

// TYPOGRAPHY
$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'     => 'content_title_typography',
        'label'    => __( 'Typography', 'choicy-core' ),
        'selector' => '{{WRAPPER}} .contact-page-contact-list .title',
    ]
);

// CONTENT DESCRIPTION COLOR
$this->add_control(
    'content_description_color',
    [
        'label'     => __( 'Description Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .contact-page-contact-list .content-wrap'   => 'color: {{VALUE}};',
            '{{WRAPPER}} .contact-page-contact-list .content-wrap a' => 'color: {{VALUE}};',
        ],
    ]
);

// TYPOGRAPHY
$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'     => 'content_description_typography',
        'label'    => __( 'Typography', 'choicy-core' ),
        'selector' => '
            {{WRAPPER}} .contact-page-contact-list .content-wrap,
            {{WRAPPER}} .contact-page-contact-list .content-wrap a
        ',
    ]
);

// END
$this->end_controls_section();