<?php
    if ( $settings['enable_animation'] === 'yes' ) {
        $anim_class = 'chyScl ';
    } else {
        $anim_class = '';
    }
?>
<div class="career-page-item">
    <div class="icon-wrap">
        <?php if ( $settings['enable_icon'] === 'yes' ): ?>
        <div class="icon">
            <?php if ( $settings['type'] == 'icon' ): ?>
                <?php \Elementor\Icons_Manager::render_icon( $settings['info_icon'], ['aria-hidden' => 'true'] );?>
            <?php else: ?>
                <img src="<?php echo esc_url( $settings['info_image']['url'] ); ?>" alt="" />
            <?php endif;?>
        </div>
        <?php endif;?>

        <?php if(!empty( $settings['job_type'] )) : ?>
        <span class="chy-heading-1 full-time"><?php echo elh_element_kses_intermediate( $settings['job_type'] ); ?></span>
        <?php endif; ?>
    </div>

    <?php if(!empty( $settings['title'] )) : ?>
    <h4 class="chy-heading-1 title"><?php echo elh_element_kses_intermediate( $settings['title'] ); ?></h4>
    <?php endif; ?>

    <div class="meta">
        <?php if(!empty( $settings['location'] )) : ?>
        <span class="chy-para-1 loc">
            <?php \Elementor\Icons_Manager::render_icon( $settings['location_icon'], ['aria-hidden' => 'true'] );?>
            <?php echo esc_html($settings['location']); ?>
        </span>
        <?php endif; ?>

        <?php if(!empty( $settings['date'] )) : ?>
        <span class="chy-para-1 date">
            <?php \Elementor\Icons_Manager::render_icon( $settings['date_icon'], ['aria-hidden' => 'true'] );?>
            <?php echo esc_html($settings['date']); ?>
        </span>
        <?php endif; ?>
    </div>

    <?php if(!empty( $settings['description'] )) : ?>
    <p class="chy-para-1 disc"><?php echo elh_element_kses_intermediate( $settings['description'] ); ?></p>
    <?php endif; ?>

    <div class="btn-wrap">
        <?php if(!empty( $settings['button_text'] )) : ?>
        <a class="chy-pr-btn-1" href="<?php echo $settings['button_link']['url'] ? esc_url( $settings['button_link']['url'] ) : ''; ?>">
            <span class="text">
                <?php echo elh_element_kses_intermediate( $settings['button_text'] ); ?>
            </span>

            <?php if(!empty(  $settings['button_icon'] )) : ?>
            <span class="icon">
                <?php \Elementor\Icons_Manager::render_icon( $settings['button_icon'], ['aria-hidden' => 'true'] );?>
            </span>
            <?php endif; ?>
        </a>
        <?php endif; ?>

        <?php if(!empty( $settings['sallery'] )) : ?>
        <h4 class="chy-heading-1 price"><?php echo esc_html($settings['sallery']); ?></h4>
        <?php endif; ?>
    </div>
</div>