<?php

    $button_class = '';
    if($settings['button_full_width'] == 'yes') {
        $button_class = 'fullWidth';
    } else {
        $button_class = '';
    }

    $button_alignment = $settings['button_alignment'];

    if($button_alignment == 'left') {
        $button_class .= ' text-left';
    } elseif($button_alignment == 'center') {
        $button_class .= ' text-center';
    } elseif($button_alignment == 'right') {
        $button_class .= ' text-right';
    }
?>
<div class="btn-wrapper wow fadeInUp <?php echo esc_attr($button_class); ?>" data-wow-delay=".3s">
    <a
    class="chy-pr-btn-5 tx-button <?php echo $settings['anim_name'] ? esc_attr($settings['anim_name']) : ''; ?>"
    href="<?php echo $settings['button_link']['url'] ? esc_url($settings['button_link']['url']) : ''; ?>"
    target="<?php echo esc_attr( $settings['button_link']['is_external'] ? '_blank' : '_self' ); ?>"
    rel="<?php echo esc_attr( $settings['button_link']['nofollow'] ? 'nofollow' : '' ); ?>">
        <span class="text">
            <?php echo elh_element_kses_intermediate($settings['button_text']); ?>
        </span>
        <span class="icon">
            <?php \Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] ); ?>
        </span>
    </a>
</div>
