<?php

namespace ElementHelper\Widget;

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Utils;

defined( 'ABSPATH' ) || die();

class Tx_Brand extends Element_El_Widget {

    /**
     * Slider Style Dependency
     *
     * @return void
     */
    public function get_style_depends() {
        return [ 'brand-2' ];
    }

    /**
     * Get widget name.
     *
     * Retrieve Choicy Core widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'tx_brand';
    }

    /**
     * Get widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title() {
        return __( 'TX Brand', 'choicy-core' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.themexriver.com/widgets/gradient-heading/';
    }

    /**
     * Get widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'elh-widget-icon eicon-t-letter';
    }

    public function get_keywords() {
        return ['brand', 'image', 'icon', 'choicy'];
    }

    protected function register_content_controls() {

        //Settings
        $this->start_controls_section(
            '_section_settings',
            [
                'label' => __( 'Settings', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'choicy-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'choicy-core' ),
                    'style_2' => __( 'Style 2', 'choicy-core' ),
                    'style_3' => __( 'Style 3', 'choicy-core' ),
                    'style_4' => __( 'Style 4', 'choicy-core' ),
                    'style_5' => __( 'Style 5', 'choicy-core' ),
                    'style_6' => __( 'Style 6', 'choicy-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_title',
            [
                'label' => __( 'Brands Image', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'brands_image',
			[
				'label' => esc_html__( 'Add Images', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::GALLERY,
				'show_label' => false,
				'default' => [],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            '_fanfact',
            [
                'label' => __( 'Fanfact', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'enable_counter',
            [
                'label'        => __( 'Enable Counter', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'choicy-core' ),
                'label_off'    => __( 'Hide', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition'   => [
                    'design_style' => 'style_6',
                ],
            ]
        );
        $this->add_control(
            'count',
            [
                'label'       => __( 'Count', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXT,
                'rows'        => 4,
                'default'     => '5.2',
                'placeholder' => __( 'Add Counter Number Here', 'choicy-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'design_style' => 'style_6',
                ],
            ]
        );
        $this->add_control(
            'prefix',
            [
                'label'       => __( 'Prefix', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXT,
                'rows'        => 4,
                'default'     => 'k',
                'placeholder' => __( 'Counter Prefix', 'choicy-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'design_style' => 'style_6',
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Counter Title', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXT,
                'rows'        => 4,
                'default'     => 'Clients Satisfactions',
                'placeholder' => __( 'Counter Prefix', 'choicy-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'design_style' => 'style_6',
                ],
            ]
        );
        $this->add_control(
            'c_image',
            [
                'label'       => __( 'Counter Image', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::MEDIA,
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'design_style' => 'style_6',
                ],
            ]
        );
        $this->end_controls_section();

    }

    protected function register_style_controls() {

        $dir = dirname( __FILE__ );

        $style_files = glob( $dir . '/styles/*.php' );

        if ( $style_files ) {
            foreach ( $style_files as $style_file ) {
                include $style_file;
            }
        }
    }

    protected function render() {

        $settings = $this->get_settings_for_display();
        $dir = dirname( __FILE__ );

        $style = !empty($settings['design_style']) ? $settings['design_style'] : 'style_1';

        switch ($style) {
            case 'style_6':
                include $dir . '/views/view-6.php';
                break;

            case 'style_5':
                include $dir . '/views/view-5.php';
                break;
            case 'style_4':
                include $dir . '/views/view-4.php';
                break;
            case 'style_3':
                include $dir . '/views/view-3.php';
                break;
            case 'style_2':
                include $dir . '/views/view-2.php';
                break;
            default:
                include $dir . '/views/view-1.php';
        }
    }
}
