<?php

    $subtitle_animation = '';
    if( $settings['enable_sub_title'] === 'yes' ) {
        if($settings['enable_sub_title_anim'] === 'yes') {
            $subtitle_animation = 'wow '.$settings['sub_title_animation'];
        } else {
            $subtitle_animation = '';
        }
    } else {
        $subtitle_animation = '';
    }

    $title_animation = '';
    if( $settings['enable_title'] === 'yes' ) {
        if($settings['enable_title_anim'] === 'yes') {
            $title_animation = 'chy-split-text '.$settings['title_animation'];
        } else {
            $title_animation = '';
        }
    } else {
        $title_animation = '';
    }

    $description_animation = '';
    if( $settings['enable_description'] === 'yes' ) {
        if($settings['enable_description_anim'] === 'yes') {
            $description_animation = 'wow '.$settings['description_animation'];
        } else {
            $description_animation = '';
        }
    } else {
        $description_animation = '';
    }

    if($settings['enable_sub_title'] === 'yes' && $settings['enable_sub_title_shape'] === 'yes' ) {
        $sub_title_shape = ' isShape';
    } else {
        $sub_title_shape = ' noShape';

    }

?>
<div class="chy-solutions-2-area bg-default" data-background="<?php echo $settings['bg_image']['url'] ? esc_url($settings['bg_image']['url']) : ''; ?>">
    <div class="container chy-container-1">
        <div class="chy-solutions-2-wrap">
            <div class="chy-solutions-2-content">
                <!-- section-title -->
                <div class="section-title-wrap mb-30">
                    <?php if( $settings['enable_sub_title'] === 'yes' ) : ?>
                    <h5 class="chy-subtitle-2 tx-subTitle <?php echo esc_attr($subtitle_animation . $sub_title_shape); ?>">
                        <?php if(!empty( $settings['sub_title_icon_image']['url'] )) : ?>
                        <img src="<?php echo esc_url($settings['sub_title_icon_image']['url']); ?>" alt="">
                        <?php endif; ?>

                        <?php echo elh_element_kses_intermediate($settings['sub_title']); ?>
                    </h5>
                    <?php endif; ?>

                    <?php
                        $this->add_render_attribute( 'title', 'class', 'tx-title chy-title-2 '.esc_attr($title_animation).'' );
                        if($settings['enable_title'] === 'yes') {
                            printf('<%1$s %2$s>%3$s</%1$s>',
                                tag_escape($settings['title_tag']),
                                $this->get_render_attribute_string('title'),
                                elh_element_kses_intermediate($settings['title'])
                            );
                        }
                    ?>

                    <?php if($settings['enable_description'] === 'yes') : ?>
                    <p class="tx-description chy-para-2 <?php echo esc_attr($description_animation); ?>">
                        <?php echo elh_element_kses_intermediate($settings['description']); ?>
                    </p>
                    <?php endif; ?>
                </div>

                <?php if( $settings['enable_feature_lists'] === 'yes' ) : ?>
                <div class="inner-div mb-40">
                    <?php if(!empty( $settings['feature_image']['url'] )) : ?>
                    <img src="<?php echo esc_url($settings['feature_image']['url']); ?>" class="certi-img chyroted" alt="">
                    <?php endif; ?>
                    <ul class="solutions-2-list list-unstyled tx-listsItems">
                        <?php foreach($settings['feature_lists'] as $list ) : ?>
                        <li class="wow fadeInUp" data-wow-delay="0">
                            <?php
                                if( $list['enable_icon'] === 'yes' ) {
                                    \Elementor\Icons_Manager::render_icon( $list['feature_icon'], [ 'aria-hidden' => 'true' ] );
                                }
                            ?>
                            <?php echo elh_element_kses_intermediate($list['title']); ?>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>

                <?php if( $settings['enable_button'] === 'yes' ) : ?>
                <a class="chy-pr-btn-3 wow fadeInUp tx-button" data-wow-delay=".6s" href="<?php echo $settings['button_link']['url'] ? esc_url($settings['button_link']['url']) : ''; ?>" target="<?php echo esc_attr( $settings['button_link']['is_external'] ? '_blank' : '_self' ); ?>" rel="<?php echo esc_attr( $settings['button_link']['nofollow'] ? 'nofollow' : '' ); ?>">
                    <span class="text"><?php echo elh_element_kses_intermediate($settings['button_text']); ?></span>
                    <?php \Elementor\Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                </a>
                <?php endif; ?>

            </div>

            <?php if( $settings['enable_count_box'] === 'yes' ) : ?>
            <div class="chy-solutions-2-counter-wrap">

                <?php foreach($settings['count_boxs'] as $list ) : ?>
                <div class="chy-solutions-2-counter wow fadeInUp">
                    <h3 class="chy-heading-1 number">
                    <span class="counter odometer" class="odometer" data-count="<?php echo esc_html( $list['count_number'] ); ?>">00</span><?php echo esc_html($list['prefix']); ?></h3>
                    <p class="chy-para-2 disc"><?php echo elh_element_kses_intermediate($list['description']); ?></p>
                </div>
                <?php endforeach; ?>

            </div>
            <?php endif; ?>


            <?php if( $settings['enable_video_box'] === 'yes' ) : ?>
            <a aria-label="link" class="chy-plybtn-2 popup-video" href="<?php echo esc_url($settings['video_button_link']['url']); ?>" >
                <?php \Elementor\Icons_Manager::render_icon( $settings['video_button_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                <?php if(!empty( $settings['video_button_image']['url'] )) : ?>
                <img class="text-img" src="<?php echo esc_url($settings['video_button_image']['url']); ?>" alt="">
                <?php endif; ?>
            </a>
            <?php endif; ?>

            <?php if(!empty( $settings['image_1']['url'] )) : ?>
            <img src="<?php echo esc_url($settings['image_1']['url']); ?>" class="hand-img" alt="">
            <?php endif; ?>

            <?php if(!empty( $settings['image_2']['url'] )) : ?>
            <img src="<?php echo esc_url($settings['image_2']['url']); ?>" class="all-icon" alt="">
            <?php endif; ?>

        </div>
    </div>
</div>