<?php
/**
 * @Template: class-mage-menu-edit.php
 * @since: 1.0.0
 * @author: Case Themes
 * @descriptions:
 * @create: 22-Nov-17
 */
if ( !defined( 'ABSPATH' ) ) {
    die();
}

class Choicy_Mega_Menu_Edit_Walker extends Walker_Nav_Menu_Edit {
    protected $mega_locations;

//    private $extra_menu= $extra_menu_custom;

    function __construct() {

        $this->megamenus = get_posts( [
            'post_type'      => 'tf-mega-menu',
            'posts_per_page' => '-1',
        ] );
        $this->walker_args = [
            'depth'       => 0,
            'child_of'    => 0,
            'selected'    => 0,
            'value_field' => 'ID',
        ];
    }

    /**
     * Start the element output.
     *
     * @see Walker_Nav_Menu::start_el()
     */
    function start_el( &$output, $item, $depth = 0, $args = [], $id = 0 ) {
        $item_output = '';
        parent::start_el( $item_output, $item, $depth, $args, $id );

        // Adding new Fields
        $item_output = str_replace( '<fieldset class="field-move', $this->get_fields( $item, $depth, $args, $id ) . '<fieldset class="field-move', $item_output );

        $output .= $item_output;
    }

    function get_fields( $item, $depth = 0, $args = [], $id = 0 ) {
        $enable_megamenu = apply_filters( 'ct_enable_megamenu', false );
        $enable_ongpage_option = apply_filters( 'ct_enable_onepage', true );
        $this->mega_locations = apply_filters( 'ct_locations', [ 'primary' ] );
        $check_mega = true;
        $nav_menu_selected_id = isset( $_REQUEST['menu'] ) ? (int) $_REQUEST['menu'] : intval( get_user_option( 'nav_menu_recently_edited' ) );
        $locations = get_registered_nav_menus();
        $menu_locations = get_nav_menu_locations();
        $key = array_search( $nav_menu_selected_id, $menu_locations, true );
        if ( in_array( $nav_menu_selected_id, $menu_locations ) && isset( $locations[$key] ) && in_array( $key, $this->mega_locations ) ) {
            $check_mega = true;
        }

        ob_start();

        $item_id = esc_attr( $item->ID );
        ?>

    <?php if ( 0 === $depth && $check_mega && $enable_megamenu === true ): ?>
        <p class="description description-wide">
            <label for="edit-menu-item-ct-megaprofile-<?php echo esc_attr( $item_id ); ?>">
                <?php esc_html_e( 'Select Mega Menu', CHOICY_CORE_TEXT_DOMAIN );?><br/>
                <select id="edit-menu-item-ct-megaprofile-<?php echo esc_attr( $item_id ); ?>" class="widefat"
                        name="menu-item-ct-megaprofile[<?php echo esc_attr( $item_id ); ?>]">
                    <option value="0"><?php esc_html_e( 'None', CHOICY_CORE_TEXT_DOMAIN )?></option>
                    <?php
                        $r = $this->walker_args;
                        $r['selected'] = $item->ct_megaprofile;
                        echo walk_page_dropdown_tree( $this->megamenus, $r['depth'], $r );
                    ?>
                </select>
            </label>
        </p>
    <?php endif;?>


    <?php if ( $enable_ongpage_option && 0 === $depth ): ?>

    <?php endif;
        global $extra_menu_custom;
        if ( !empty( $extra_menu_custom ) ) {
            foreach ( $extra_menu_custom as $key => $fields ) {
                $fields["allow_primary"] = isset( $fields["allow_primary"] ) ? $fields["allow_primary"] : true;
                if ( in_array( $depth, $fields['lever_support'] ) && (  ( $check_mega === true && $fields["allow_primary"] === true ) || $fields["allow_primary"] === false ) ):
                ?>
                    <p class="description description-wide">
                        <label for="menu-item-<?php echo esc_attr( $key ) ?>-<?php echo esc_attr( $item_id ); ?>">
                            <?php echo esc_attr( $fields['label'] ) ?><br/>
                            <select id="menu-item-<?php echo esc_attr( $key ) ?>-<?php echo esc_attr( $item_id ); ?>"
                                    class="widefat menu-item-<?php echo esc_attr( $key ) ?>"
                                    name="menu-item-<?php echo esc_attr( $key ) ?>[<?php echo esc_attr( $item_id ); ?>]">
                                <?php
                                    foreach ( $fields["options"] as $val => $text ) {
                                ?>
                                    <option value="<?php echo esc_attr( $val ) ?>" <?php selected( esc_attr( $item->$key ), $val )?>><?php echo esc_attr( $text ) ?></option>
                                    <?php
                                    }
                                 ?>
                            </select>
                        </label>
                    </p>
                <?php
            endif;
            }
        }

        ?>
        <script>
            jQuery('.ct-icon-picker').fontIconPicker();
        </script>

        <?php
        return ob_get_clean();
    }

    function ct_iconpicker_fontawesome() {
        // Categorized icons ( you can also output simple array ( key=> value ), where key = icon class, value = icon readable name ).
        /**
         * @version 4.6.3
         */
        $icons = [
            'New in 4.6'            => [
                [ 'fa fa-instagram' => 'Instagram' ],
                [ 'fa fa-gitlab' => 'GitLab' ],
                [ 'fa fa-wpbeginner' => 'WPBeginner' ],
                [ 'fa fa-wpforms' => 'WPForms' ],
                [ 'fa fa-envira' => 'Envira Gallery(leaf)' ],
                [ 'fa fa-universal-access' => 'Universal Access' ],
                [ 'fa fa-wheelchair-alt' => 'Wheelchair Alt' ],
                [ 'fa fa-question-circle-o' => 'Question Circle Outlined' ],
                [ 'fa fa-blind' => 'Blind' ],
                [ 'fa fa-audio-description' => 'Audio Description' ],
                [ 'fa fa-volume-control-phone' => 'Volume Control Phone' ],
                [ 'fa fa-braille' => 'Braille' ],
                [ 'fa fa-assistive-listening-systems' => 'Assistive Listening Systems' ],
                [ 'fa fa-american-sign-language-interpreting' => 'American Sign Language Interpreting(asl-interpreting)' ],
                [ 'fa fa-deaf' => 'Deaf(deafness, hard-of-hearing)' ],
                [ 'fa fa-glide' => 'Glide' ],
                [ 'fa fa-glide-g' => 'Glide G' ],
                [ 'fa fa-sign-language' => 'Sign Language(signing)' ],
                [ 'fa fa-low-vision' => 'Low Vision' ],
                [ 'fa fa-viadeo' => 'Viadeo' ],
                [ 'fa fa-viadeo-square' => 'Viadeo Square' ],
                [ 'fa fa-snapchat' => 'Snapchat' ],
                [ 'fa fa-snapchat-ghost' => 'Snapchat Ghost' ],
                [ 'fa fa-snapchat-square' => 'Snapchat Square' ],
                [ 'fa fa-pied-piper' => 'Pied Piper Logo' ],
                [ 'fa fa-first-order' => 'First Order' ],
                [ 'fa fa-yoast' => 'Yoast' ],
                [ 'fa fa-themeisle' => 'ThemeIsle' ],
                [ 'fa fa-google-plus-official' => 'Google Plus Official(google-plus-circle)' ],
                [ 'fa fa-font-awesome' => 'Font Awesome(fa)' ],
            ],
            'Web Application Icons' => [
                [ 'fa fa-glass' => 'Glass(martini, drink, bar, alcohol, liquor)' ],
                [ 'fa fa-music' => 'Music(note, sound)' ],
                [ 'fa fa-search' => 'Search(magnify, zoom, enlarge, bigger)' ],
                [ 'fa fa-envelope-o' => 'Envelope Outlined(email, support, e-mail, letter, mail, notification)' ],
                [ 'fa fa-heart' => 'Heart(love, like, favorite)' ],
                [ 'fa fa-star' => 'Star(award, achievement, night, rating, score, favorite)' ],
                [ 'fa fa-star-o' => 'Star Outlined(award, achievement, night, rating, score, favorite)' ],
                [ 'fa fa-user' => 'User(person, man, head, profile)' ],
                [ 'fa fa-film' => 'Film(movie)' ],
                [ 'fa fa-check' => 'Check(checkmark, done, todo, agree, accept, confirm, tick, ok)' ],
                [ 'fa fa-times' => 'Times(close, exit, x, cross)(remove, close)' ],
                [ 'fa fa-search-plus' => 'Search Plus(magnify, zoom, enlarge, bigger)' ],
                [ 'fa fa-search-minus' => 'Search Minus(magnify, minify, zoom, smaller)' ],
                [ 'fa fa-power-off' => 'Power Off(on)' ],
                [ 'fa fa-signal' => 'signal(graph, bars)' ],
                [ 'fa fa-cog' => 'cog(settings)(gear)' ],
                [ 'fa fa-trash-o' => 'Trash Outlined(garbage, delete, remove, trash, hide)' ],
                [ 'fa fa-home' => 'home(main, house)' ],
                [ 'fa fa-clock-o' => 'Clock Outlined(watch, timer, late, timestamp)' ],
                [ 'fa fa-road' => 'road(street)' ],
                [ 'fa fa-download' => 'Download(import)' ],
                [ 'fa fa-inbox' => 'inbox' ],
                [ 'fa fa-refresh' => 'refresh(reload, sync)' ],
                [ 'fa fa-lock' => 'lock(protect, admin)' ],
                [ 'fa fa-flag' => 'flag(report, notification, notify)' ],
                [ 'fa fa-headphones' => 'headphones(sound, listen, music, audio)' ],
                [ 'fa fa-volume-off' => 'volume-off(audio, mute, sound, music)' ],
                [ 'fa fa-volume-down' => 'volume-down(audio, lower, quieter, sound, music)' ],
                [ 'fa fa-volume-up' => 'volume-up(audio, higher, louder, sound, music)' ],
                [ 'fa fa-qrcode' => 'qrcode(scan)' ],
                [ 'fa fa-barcode' => 'barcode(scan)' ],
                [ 'fa fa-tag' => 'tag(label)' ],
                [ 'fa fa-tags' => 'tags(labels)' ],
                [ 'fa fa-book' => 'book(read, documentation)' ],
                [ 'fa fa-bookmark' => 'bookmark(save)' ],
                [ 'fa fa-print' => 'print' ],
                [ 'fa fa-camera' => 'camera(photo, picture, record)' ],
                [ 'fa fa-video-camera' => 'Video Camera(film, movie, record)' ],
                [ 'fas fa-image' => 'Picture Outlined(photo, image)' ],
                [ 'fa fa-pencil' => 'pencil(write, edit, update)' ],
                [ 'fa fa-map-marker' => 'map-marker(map, pin, location, coordinates, localize, address, travel, where, place)' ],
                [ 'fa fa-adjust' => 'adjust(contrast)' ],
                [ 'fa fa-tint' => 'tint(raindrop, waterdrop, drop, droplet)' ],
                [ 'fa fa-pencil-square-o' => 'Pencil Square Outlined(write, edit, update)(edit)' ],
                [ 'fa fa-share-square-o' => 'Share Square Outlined(social, send, arrow)' ],
                [ 'fa fa-check-square-o' => 'Check Square Outlined(todo, done, agree, accept, confirm, ok)' ],
                [ 'fa fa-arrows' => 'Arrows(move, reorder, resize)' ],
                [ 'fa fa-plus-circle' => 'Plus Circle(add, new, create, expand)' ],
                [ 'fa fa-minus-circle' => 'Minus Circle(delete, remove, trash, hide)' ],
                [ 'fa fa-times-circle' => 'Times Circle(close, exit, x)' ],
                [ 'fa fa-check-circle' => 'Check Circle(todo, done, agree, accept, confirm, ok)' ],
                [ 'fa fa-question-circle' => 'Question Circle(help, information, unknown, support)' ],
                [ 'fa fa-info-circle' => 'Info Circle(help, information, more, details)' ],
                [ 'fa fa-crosshairs' => 'Crosshairs(picker)' ],
                [ 'fa fa-times-circle-o' => 'Times Circle Outlined(close, exit, x)' ],
                [ 'fa fa-check-circle-o' => 'Check Circle Outlined(todo, done, agree, accept, confirm, ok)' ],
                [ 'fa fa-ban' => 'ban(delete, remove, trash, hide, block, stop, abort, cancel)' ],
                [ 'fa fa-share' => 'Share(mail-forward)' ],
                [ 'fa fa-plus' => 'plus(add, new, create, expand)' ],
                [ 'fa fa-minus' => 'minus(hide, minify, delete, remove, trash, hide, collapse)' ],
                [ 'fa fa-asterisk' => 'asterisk(details)' ],
                [ 'fa fa-exclamation-circle' => 'Exclamation Circle(warning, error, problem, notification, alert)' ],
                [ 'fa fa-gift' => 'gift(present)' ],
                [ 'fa fa-leaf' => 'leaf(eco, nature, plant)' ],
                [ 'fa fa-fire' => 'fire(flame, hot, popular)' ],
                [ 'fa fa-eye' => 'Eye(show, visible, views)' ],
                [ 'fa fa-eye-slash' => 'Eye Slash(toggle, show, hide, visible, visiblity, views)' ],
                [ 'fa fa-exclamation-triangle' => 'Exclamation Triangle(warning, error, problem, notification, alert)(warning)' ],
                [ 'fa fa-plane' => 'plane(travel, trip, location, destination, airplane, fly, mode)' ],
                [ 'fa fa-calendar' => 'calendar(date, time, when, event)' ],
                [ 'fa fa-random' => 'random(sort, shuffle)' ],
                [ 'fa fa-comment' => 'comment(speech, notification, note, chat, bubble, feedback, message, texting, sms)' ],
                [ 'fa fa-magnet' => 'magnet' ],
                [ 'fa fa-retweet' => 'retweet(refresh, reload, share)' ],
                [ 'fa fa-shopping-cart' => 'shopping-cart(checkout, buy, purchase, payment)' ],
                [ 'fa fa-folder' => 'Folder' ],
                [ 'fa fa-folder-open' => 'Folder Open' ],
                [ 'fa fa-arrows-v' => 'Arrows Vertical(resize)' ],
                [ 'fa fa-arrows-h' => 'Arrows Horizontal(resize)' ],
                [ 'fa fa-bar-chart' => 'Bar Chart(graph, analytics)(bar-chart-o)' ],
                [ 'fa fa-camera-retro' => 'camera-retro(photo, picture, record)' ],
                [ 'fa fa-key' => 'key(unlock, password)' ],
                [ 'fa fa-cogs' => 'cogs(settings)(gears)' ],
                [ 'fa fa-comments' => 'comments(conversation, notification, notes, message, texting, sms, chat)' ],
                [ 'fa fa-thumbs-o-up' => 'Thumbs Up Outlined(like, approve, favorite, agree, hand)' ],
                [ 'fa fa-thumbs-o-down' => 'Thumbs Down Outlined(dislike, disapprove, disagree, hand)' ],
                [ 'fa fa-star-half' => 'star-half(award, achievement, rating, score)' ],
                [ 'fa fa-heart-o' => 'Heart Outlined(love, like, favorite)' ],
                [ 'fa fa-sign-out' => 'Sign Out(log out, logout, leave, exit, arrow)' ],
                [ 'fa fa-thumb-tack' => 'Thumb Tack(marker, pin, location, coordinates)' ],
                [ 'fa fa-external-link' => 'External Link(open, new)' ],
                [ 'fa fa-sign-in' => 'Sign In(enter, join, log in, login, sign up, sign in, signin, signup, arrow)' ],
                [ 'fa fa-trophy' => 'trophy(award, achievement, winner, game)' ],
                [ 'fa fa-upload' => 'Upload(import)' ],
                [ 'fa fa-lemon-o' => 'Lemon Outlined(food)' ],
                [ 'fa fa-phone' => 'Phone(call, voice, number, support, earphone)' ],
                [ 'fa fa-square-o' => 'Square Outlined(block, square, box)' ],
                [ 'fa fa-bookmark-o' => 'Bookmark Outlined(save)' ],
                [ 'fa fa-phone-square' => 'Phone Square(call, voice, number, support)' ],
                [ 'fa fa-unlock' => 'unlock(protect, admin, password, lock)' ],
                [ 'fa fa-credit-card' => 'credit-card(money, buy, debit, checkout, purchase, payment)' ],
                [ 'fa fa-rss' => 'rss(blog)(feed)' ],
                [ 'fa fa-hdd-o' => 'HDD(harddrive, hard drive, storage, save)' ],
                [ 'fa fa-bullhorn' => 'bullhorn(announcement, share, broadcast, louder)' ],
                [ 'fa fa-bell' => 'bell(alert, reminder, notification)' ],
                [ 'fa fa-certificate' => 'certificate(badge, star)' ],
                [ 'fa fa-globe' => 'Globe(world, planet, map, place, travel, earth, global, translate, all, language, localize, location, coordinates, country)' ],
                [ 'fa fa-wrench' => 'Wrench(settings, fix, update)' ],
                [ 'fa fa-tasks' => 'Tasks(progress, loading, downloading, downloads, settings)' ],
                [ 'fa fa-filter' => 'Filter(funnel, options)' ],
                [ 'fa fa-briefcase' => 'Briefcase(work, business, office, luggage, bag)' ],
                [ 'fa fa-users' => 'Users(people, profiles, persons)(group)' ],
                [ 'fa fa-cloud' => 'Cloud(save)' ],
                [ 'fa fa-flask' => 'Flask(science, beaker, experimental, labs)' ],
                [ 'fa fa-square' => 'Square(block, box)' ],
                [ 'fa fa-bars' => 'Bars(menu, drag, reorder, settings, list, ul, ol, checklist, todo, list, hamburger)(navicon, reorder)' ],
                [ 'fa fa-magic' => 'magic(wizard, automatic, autocomplete)' ],
                [ 'fa fa-truck' => 'truck(shipping)' ],
                [ 'fa fa-money' => 'Money(cash, money, buy, checkout, purchase, payment)' ],
                [ 'fa fa-sort' => 'Sort(order)(unsorted)' ],
                [ 'fa fa-sort-desc' => 'Sort Descending(dropdown, more, menu, arrow)(sort-down)' ],
                [ 'fa fa-sort-asc' => 'Sort Ascending(arrow)(sort-up)' ],
                [ 'fa fa-envelope' => 'Envelope(email, e-mail, letter, support, mail, notification)' ],
                [ 'fa fa-gavel' => 'Gavel(legal)' ],
                [ 'fa fa-tachometer' => 'Tachometer(dashboard)' ],
                [ 'fa fa-comment-o' => 'comment-o(speech, notification, note, chat, bubble, feedback, message, texting, sms)' ],
                [ 'fa fa-comments-o' => 'comments-o(conversation, notification, notes, message, texting, sms, chat)' ],
                [ 'fa fa-bolt' => 'Lightning Bolt(lightning, weather)(flash)' ],
                [ 'fa fa-sitemap' => 'Sitemap(directory, hierarchy, organization)' ],
                [ 'fa fa-umbrella' => 'Umbrella' ],
                [ 'fa fa-lightbulb-o' => 'Lightbulb Outlined(idea, inspiration)' ],
                [ 'fa fa-exchange' => 'Exchange(transfer, arrows, arrow)' ],
                [ 'fa fa-cloud-download' => 'Cloud Download(import)' ],
                [ 'fa fa-cloud-upload' => 'Cloud Upload(import)' ],
                [ 'fa fa-suitcase' => 'Suitcase(trip, luggage, travel, move, baggage)' ],
                [ 'fa fa-bell-o' => 'Bell Outlined(alert, reminder, notification)' ],
                [ 'fa fa-coffee' => 'Coffee(morning, mug, breakfast, tea, drink, cafe)' ],
                [ 'fa fa-cutlery' => 'Cutlery(food, restaurant, spoon, knife, dinner, eat)' ],
                [ 'fa fa-building-o' => 'Building Outlined(work, business, apartment, office, company)' ],
                [ 'fa fa-fighter-jet' => 'fighter-jet(fly, plane, airplane, quick, fast, travel)' ],
                [ 'fa fa-beer' => 'beer(alcohol, stein, drink, mug, bar, liquor)' ],
                [ 'fa fa-plus-square' => 'Plus Square(add, new, create, expand)' ],
                [ 'fa fa-desktop' => 'Desktop(monitor, screen, desktop, computer, demo, device)' ],
                [ 'fa fa-laptop' => 'Laptop(demo, computer, device)' ],
                [ 'fa fa-tablet' => 'tablet(ipad, device)' ],
                [ 'fa fa-mobile' => 'Mobile Phone(cell phone, cellphone, text, call, iphone, number)(mobile-phone)' ],
                [ 'fa fa-circle-o' => 'Circle Outlined' ],
                [ 'fa fa-quote-left' => 'quote-left' ],
                [ 'fa fa-quote-right' => 'quote-right' ],
                [ 'fa fa-spinner' => 'Spinner(loading, progress)' ],
                [ 'fa fa-circle' => 'Circle(dot, notification)' ],
                [ 'fa fa-reply' => 'Reply(mail-reply)' ],
                [ 'fa fa-folder-o' => 'Folder Outlined' ],
                [ 'fa fa-folder-open-o' => 'Folder Open Outlined' ],
                [ 'fa fa-smile-o' => 'Smile Outlined(face, emoticon, happy, approve, satisfied, rating)' ],
                [ 'fa fa-frown-o' => 'Frown Outlined(face, emoticon, sad, disapprove, rating)' ],
                [ 'fa fa-meh-o' => 'Meh Outlined(face, emoticon, rating, neutral)' ],
                [ 'fa fa-gamepad' => 'Gamepad(controller)' ],
                [ 'fa fa-keyboard-o' => 'Keyboard Outlined(type, input)' ],
                [ 'fa fa-flag-o' => 'Flag Outlined(report, notification)' ],
                [ 'fa fa-flag-checkered' => 'flag-checkered(report, notification, notify)' ],
                [ 'fa fa-terminal' => 'Terminal(command, prompt, code)' ],
                [ 'fa fa-code' => 'Code(html, brackets)' ],
                [ 'fa fa-reply-all' => 'reply-all(mail-reply-all)' ],
                [ 'fa fa-star-half-o' => 'Star Half Outlined(award, achievement, rating, score)(star-half-empty, star-half-full)' ],
                [ 'fa fa-location-arrow' => 'location-arrow(map, coordinates, location, address, place, where)' ],
                [ 'fa fa-crop' => 'crop' ],
                [ 'fa fa-code-fork' => 'code-fork(git, fork, vcs, svn, github, rebase, version, merge)' ],
                [ 'fa fa-question' => 'Question(help, information, unknown, support)' ],
                [ 'fa fa-info' => 'Info(help, information, more, details)' ],
                [ 'fa fa-exclamation' => 'exclamation(warning, error, problem, notification, notify, alert)' ],
                [ 'fa fa-eraser' => 'eraser(remove, delete)' ],
                [ 'fa fa-puzzle-piece' => 'Puzzle Piece(addon, add-on, section)' ],
                [ 'fa fa-microphone' => 'microphone(record, voice, sound)' ],
                [ 'fa fa-microphone-slash' => 'Microphone Slash(record, voice, sound, mute)' ],
                [ 'fa fa-shield' => 'shield(award, achievement, winner)' ],
                [ 'fa fa-calendar-o' => 'calendar-o(date, time, when, event)' ],
                [ 'fa fa-fire-extinguisher' => 'fire-extinguisher' ],
                [ 'fa fa-rocket' => 'rocket(app)' ],
                [ 'fa fa-anchor' => 'Anchor(link)' ],
                [ 'fa fa-unlock-alt' => 'Unlock Alt(protect, admin, password, lock)' ],
                [ 'fa fa-bullseye' => 'Bullseye(target)' ],
                [ 'fa fa-ellipsis-h' => 'Ellipsis Horizontal(dots)' ],
                [ 'fa fa-ellipsis-v' => 'Ellipsis Vertical(dots)' ],
                [ 'fa fa-rss-square' => 'RSS Square(feed, blog)' ],
                [ 'fa fa-ticket' => 'Ticket(movie, pass, support)' ],
                [ 'fa fa-minus-square' => 'Minus Square(hide, minify, delete, remove, trash, hide, collapse)' ],
                [ 'fa fa-minus-square-o' => 'Minus Square Outlined(hide, minify, delete, remove, trash, hide, collapse)' ],
                [ 'fa fa-level-up' => 'Level Up(arrow)' ],
                [ 'fa fa-level-down' => 'Level Down(arrow)' ],
                [ 'fa fa-check-square' => 'Check Square(checkmark, done, todo, agree, accept, confirm, ok)' ],
                [ 'fa fa-pencil-square' => 'Pencil Square(write, edit, update)' ],
                [ 'fa fa-external-link-square' => 'External Link Square(open, new)' ],
                [ 'fa fa-share-square' => 'Share Square(social, send)' ],
                [ 'fa fa-compass' => 'Compass(safari, directory, menu, location)' ],
                [ 'fa fa-caret-square-o-down' => 'Caret Square Outlined Down(more, dropdown, menu)(toggle-down)' ],
                [ 'fa fa-caret-square-o-up' => 'Caret Square Outlined Up(toggle-up)' ],
                [ 'fa fa-caret-square-o-right' => 'Caret Square Outlined Right(next, forward)(toggle-right)' ],
                [ 'fa fa-sort-alpha-asc' => 'Sort Alpha Ascending' ],
                [ 'fa fa-sort-alpha-desc' => 'Sort Alpha Descending' ],
                [ 'fa fa-sort-amount-asc' => 'Sort Amount Ascending' ],
                [ 'fa fa-sort-amount-desc' => 'Sort Amount Descending' ],
                [ 'fa fa-sort-numeric-asc' => 'Sort Numeric Ascending(numbers)' ],
                [ 'fa fa-sort-numeric-desc' => 'Sort Numeric Descending(numbers)' ],
                [ 'fa fa-thumbs-up' => 'thumbs-up(like, favorite, approve, agree, hand)' ],
                [ 'fa fa-thumbs-down' => 'thumbs-down(dislike, disapprove, disagree, hand)' ],
                [ 'fa fa-female' => 'Female(woman, user, person, profile)' ],
                [ 'fa fa-male' => 'Male(man, user, person, profile)' ],
                [ 'fa fa-sun-o' => 'Sun Outlined(weather, contrast, lighter, brighten, day)' ],
                [ 'fa fa-moon-o' => 'Moon Outlined(night, darker, contrast)' ],
                [ 'fa fa-archive' => 'Archive(box, storage)' ],
                [ 'fa fa-bug' => 'Bug(report, insect)' ],
                [ 'fa fa-caret-square-o-left' => 'Caret Square Outlined Left(previous, back)(toggle-left)' ],
                [ 'fa fa-dot-circle-o' => 'Dot Circle Outlined(target, bullseye, notification)' ],
                [ 'fa fa-wheelchair' => 'Wheelchair(handicap, person, accessibility, accessibile)' ],
                [ 'fa fa-plus-square-o' => 'Plus Square Outlined(add, new, create, expand)' ],
                [ 'fa fa-space-shuttle' => 'Space Shuttle' ],
                [ 'fa fa-envelope-square' => 'Envelope Square' ],
                [ 'fa fa-university' => 'University(institution, bank)' ],
                [ 'fa fa-graduation-cap' => 'Graduation Cap(learning, school, student)(mortar-board)' ],
                [ 'fa fa-language' => 'Language' ],
                [ 'fa fa-fax' => 'Fax' ],
                [ 'fa fa-building' => 'Building(work, business, apartment, office, company)' ],
                [ 'fa fa-child' => 'Child' ],
                [ 'fa fa-paw' => 'Paw(pet)' ],
                [ 'fa fa-spoon' => 'spoon' ],
                [ 'fa fa-cube' => 'Cube' ],
                [ 'fa fa-cubes' => 'Cubes' ],
                [ 'fa fa-recycle' => 'Recycle' ],
                [ 'fa fa-car' => 'Car(vehicle)(automobile)' ],
                [ 'fa fa-taxi' => 'Taxi(vehicle)(cab)' ],
                [ 'fa fa-tree' => 'Tree' ],
                [ 'fa fa-database' => 'Database' ],
                [ 'fa fa-file-pdf-o' => 'PDF File Outlined' ],
                [ 'fa fa-file-word-o' => 'Word File Outlined' ],
                [ 'fa fa-file-excel-o' => 'Excel File Outlined' ],
                [ 'fa fa-file-powerpoint-o' => 'Powerpoint File Outlined' ],
                [ 'fa fa-file-image-o' => 'Image File Outlined(file-photo-o, file-picture-o)' ],
                [ 'fa fa-file-archive-o' => 'Archive File Outlined(file-zip-o)' ],
                [ 'fa fa-file-audio-o' => 'Audio File Outlined(file-sound-o)' ],
                [ 'fa fa-file-video-o' => 'Video File Outlined(file-movie-o)' ],
                [ 'fa fa-file-code-o' => 'Code File Outlined' ],
                [ 'fa fa-life-ring' => 'Life Ring(life-bouy, life-buoy, life-saver, support)' ],
                [ 'fa fa-circle-o-notch' => 'Circle Outlined Notched' ],
                [ 'fa fa-paper-plane' => 'Paper Plane(send)' ],
                [ 'fa fa-paper-plane-o' => 'Paper Plane Outlined(send-o)' ],
                [ 'fa fa-history' => 'History' ],
                [ 'fa fa-circle-thin' => 'Circle Outlined Thin' ],
                [ 'fa fa-sliders' => 'Sliders(settings)' ],
                [ 'fa fa-share-alt' => 'Share Alt' ],
                [ 'fa fa-share-alt-square' => 'Share Alt Square' ],
                [ 'fa fa-bomb' => 'Bomb' ],
                [ 'fa fa-futbol-o' => 'Futbol Outlined(soccer-ball-o)' ],
                [ 'fa fa-tty' => 'TTY' ],
                [ 'fa fa-binoculars' => 'Binoculars' ],
                [ 'fa fa-plug' => 'Plug(power, connect)' ],
                [ 'fa fa-newspaper-o' => 'Newspaper Outlined(press)' ],
                [ 'fa fa-wifi' => 'WiFi' ],
                [ 'fa fa-calculator' => 'Calculator' ],
                [ 'fa fa-bell-slash' => 'Bell Slash' ],
                [ 'fa fa-bell-slash-o' => 'Bell Slash Outlined' ],
                [ 'fa fa-trash' => 'Trash(garbage, delete, remove, hide)' ],
                [ 'fa fa-copyright' => 'Copyright' ],
                [ 'fa fa-at' => 'At' ],
                [ 'fa fa-eyedropper' => 'Eyedropper' ],
                [ 'fa fa-paint-brush' => 'Paint Brush' ],
                [ 'fa fa-birthday-cake' => 'Birthday Cake' ],
                [ 'fa fa-area-chart' => 'Area Chart(graph, analytics)' ],
                [ 'fa fa-pie-chart' => 'Pie Chart(graph, analytics)' ],
                [ 'fa fa-line-chart' => 'Line Chart(graph, analytics)' ],
                [ 'fa fa-toggle-off' => 'Toggle Off' ],
                [ 'fa fa-toggle-on' => 'Toggle On' ],
                [ 'fa fa-bicycle' => 'Bicycle(vehicle, bike)' ],
                [ 'fa fa-bus' => 'Bus(vehicle)' ],
                [ 'fa fa-cc' => 'Closed Captions' ],
                [ 'fa fa-cart-plus' => 'Add to Shopping Cart(add, shopping)' ],
                [ 'fa fa-cart-arrow-down' => 'Shopping Cart Arrow Down(shopping)' ],
                [ 'fa fa-diamond' => 'Diamond(gem, gemstone)' ],
                [ 'fa fa-ship' => 'Ship(boat, sea)' ],
                [ 'fa fa-user-secret' => 'User Secret(whisper, spy, incognito, privacy)' ],
                [ 'fa fa-motorcycle' => 'Motorcycle(vehicle, bike)' ],
                [ 'fa fa-street-view' => 'Street View(map)' ],
                [ 'fa fa-heartbeat' => 'Heartbeat(ekg)' ],
                [ 'fa fa-server' => 'Server' ],
                [ 'fa fa-user-plus' => 'Add User(sign up, signup)' ],
                [ 'fa fa-user-times' => 'Remove User' ],
                [ 'fa fa-bed' => 'Bed(travel)(hotel)' ],
                [ 'fa fa-battery-full' => 'Battery Full(power)(battery-4)' ],
                [ 'fa fa-battery-three-quarters' => 'Battery 3/4 Full(power)(battery-3)' ],
                [ 'fa fa-battery-half' => 'Battery 1/2 Full(power)(battery-2)' ],
                [ 'fa fa-battery-quarter' => 'Battery 1/4 Full(power)(battery-1)' ],
                [ 'fa fa-battery-empty' => 'Battery Empty(power)(battery-0)' ],
                [ 'fa fa-mouse-pointer' => 'Mouse Pointer' ],
                [ 'fa fa-i-cursor' => 'I Beam Cursor' ],
                [ 'fa fa-object-group' => 'Object Group' ],
                [ 'fa fa-object-ungroup' => 'Object Ungroup' ],
                [ 'fa fa-sticky-note' => 'Sticky Note' ],
                [ 'fa fa-sticky-note-o' => 'Sticky Note Outlined' ],
                [ 'fa fa-clone' => 'Clone(copy)' ],
                [ 'fa fa-balance-scale' => 'Balance Scale' ],
                [ 'fa fa-hourglass-o' => 'Hourglass Outlined' ],
                [ 'fa fa-hourglass-start' => 'Hourglass Start(hourglass-1)' ],
                [ 'fa fa-hourglass-half' => 'Hourglass Half(hourglass-2)' ],
                [ 'fa fa-hourglass-end' => 'Hourglass End(hourglass-3)' ],
                [ 'fa fa-hourglass' => 'Hourglass' ],
                [ 'fa fa-hand-rock-o' => 'Rock (Hand)(hand-grab-o)' ],
                [ 'fa fa-hand-paper-o' => 'Paper (Hand)(stop)(hand-stop-o)' ],
                [ 'fa fa-hand-scissors-o' => 'Scissors (Hand)' ],
                [ 'fa fa-hand-lizard-o' => 'Lizard (Hand)' ],
                [ 'fa fa-hand-spock-o' => 'Spock (Hand)' ],
                [ 'fa fa-hand-pointer-o' => 'Hand Pointer' ],
                [ 'fa fa-hand-peace-o' => 'Hand Peace' ],
                [ 'fa fa-trademark' => 'Trademark' ],
                [ 'fa fa-registered' => 'Registered Trademark' ],
                [ 'fa fa-creative-commons' => 'Creative Commons' ],
                [ 'fa fa-television' => 'Television(display, computer, monitor)(tv)' ],
                [ 'fa fa-calendar-plus-o' => 'Calendar Plus Outlined' ],
                [ 'fa fa-calendar-minus-o' => 'Calendar Minus Outlined' ],
                [ 'fa fa-calendar-times-o' => 'Calendar Times Outlined' ],
                [ 'fa fa-calendar-check-o' => 'Calendar Check Outlined(ok)' ],
                [ 'fa fa-industry' => 'Industry(factory)' ],
                [ 'fa fa-map-pin' => 'Map Pin' ],
                [ 'fa fa-map-signs' => 'Map Signs' ],
                [ 'fa fa-map-o' => 'Map Outline' ],
                [ 'fa fa-map' => 'Map' ],
                [ 'fa fa-commenting' => 'Commenting(message)' ],
                [ 'fa fa-commenting-o' => 'Commenting Outlined(message)' ],
                [ 'fa fa-credit-card-alt' => 'Credit Card(money, buy, debit, checkout, purchase, payment, credit card)' ],
                [ 'fa fa-shopping-bag' => 'Shopping Bag' ],
                [ 'fa fa-shopping-basket' => 'Shopping Basket' ],
                [ 'fa fa-hashtag' => 'Hashtag' ],
                [ 'fa fa-bluetooth' => 'Bluetooth' ],
                [ 'fa fa-bluetooth-b' => 'Bluetooth' ],
                [ 'fa fa-percent' => 'Percent' ],
                [ 'fa fa-universal-access' => 'Universal Access' ],
                [ 'fa fa-wheelchair-alt' => 'Wheelchair Alt' ],
                [ 'fa fa-question-circle-o' => 'Question Circle Outlined' ],
                [ 'fa fa-blind' => 'Blind' ],
                [ 'fa fa-audio-description' => 'Audio Description' ],
                [ 'fa fa-volume-control-phone' => 'Volume Control Phone' ],
                [ 'fa fa-braille' => 'Braille' ],
                [ 'fa fa-assistive-listening-systems' => 'Assistive Listening Systems' ],
                [ 'fa fa-american-sign-language-interpreting' => 'American Sign Language Interpreting(asl-interpreting)' ],
                [ 'fa fa-deaf' => 'Deaf(deafness, hard-of-hearing)' ],
                [ 'fa fa-sign-language' => 'Sign Language(signing)' ],
                [ 'fa fa-low-vision' => 'Low Vision' ],
            ],
            'Medical Icons'         => [
                [ 'fa fa-heart' => 'Heart(love, like, favorite)' ],
                [ 'fa fa-heart-o' => 'Heart Outlined(love, like, favorite)' ],
                [ 'fa fa-user-md' => 'user-md(doctor, profile, medical, nurse)' ],
                [ 'fa fa-stethoscope' => 'Stethoscope' ],
                [ 'fa fa-hospital-o' => 'hospital Outlined(building)' ],
                [ 'fa fa-ambulance' => 'ambulance(vehicle, support, help)' ],
                [ 'fa fa-medkit' => 'medkit(first aid, firstaid, help, support, health)' ],
                [ 'fa fa-h-square' => 'H Square(hospital, hotel)' ],
                [ 'fa fa-plus-square' => 'Plus Square(add, new, create, expand)' ],
                [ 'fa fa-wheelchair' => 'Wheelchair(handicap, person, accessibility, accessibile)' ],
                [ 'fa fa-heartbeat' => 'Heartbeat(ekg)' ],
            ],
            'Text Editor Icons'     => [
                [ 'fa fa-th-large' => 'th-large(blocks, squares, boxes, grid)' ],
                [ 'fa fa-th' => 'th(blocks, squares, boxes, grid)' ],
                [ 'fa fa-th-list' => 'th-list(ul, ol, checklist, finished, completed, done, todo)' ],
                [ 'fa fa-file-o' => 'File Outlined(new, page, pdf, document)' ],
                [ 'fa fa-repeat' => 'Repeat(redo, forward)(rotate-right)' ],
                [ 'fa fa-list-alt' => 'list-alt(ul, ol, checklist, finished, completed, done, todo)' ],
                [ 'fa fa-font' => 'font(text)' ],
                [ 'fa fa-bold' => 'bold' ],
                [ 'fa fa-italic' => 'italic(italics)' ],
                [ 'fa fa-text-height' => 'text-height' ],
                [ 'fa fa-text-width' => 'text-width' ],
                [ 'fa fa-align-left' => 'align-left(text)' ],
                [ 'fa fa-align-center' => 'align-center(middle, text)' ],
                [ 'fa fa-align-right' => 'align-right(text)' ],
                [ 'fa fa-align-justify' => 'align-justify(text)' ],
                [ 'fa fa-list' => 'list(ul, ol, checklist, finished, completed, done, todo)' ],
                [ 'fa fa-outdent' => 'Outdent(dedent)' ],
                [ 'fa fa-indent' => 'Indent' ],
                [ 'fa fa-link' => 'Link(chain)(chain)' ],
                [ 'fa fa-scissors' => 'Scissors(cut)' ],
                [ 'fa fa-files-o' => 'Files Outlined(duplicate, clone, copy)(copy)' ],
                [ 'fa fa-paperclip' => 'Paperclip(attachment)' ],
                [ 'fa fa-floppy-o' => 'Floppy Outlined(save)' ],
                [ 'fa fa-list-ul' => 'list-ul(ul, ol, checklist, todo, list)' ],
                [ 'fa fa-list-ol' => 'list-ol(ul, ol, checklist, list, todo, list, numbers)' ],
                [ 'fa fa-strikethrough' => 'Strikethrough' ],
                [ 'fa fa-underline' => 'Underline' ],
                [ 'fa fa-table' => 'table(data, excel, spreadsheet)' ],
                [ 'fa fa-columns' => 'Columns(split, panes)' ],
                [ 'fa fa-undo' => 'Undo(back)(rotate-left)' ],
                [ 'fa fa-clipboard' => 'Clipboard(copy)(paste)' ],
                [ 'fa fa-file-text-o' => 'File Text Outlined(new, page, pdf, document)' ],
                [ 'fa fa-chain-broken' => 'Chain Broken(remove)(unlink)' ],
                [ 'fa fa-superscript' => 'superscript(exponential)' ],
                [ 'fa fa-subscript' => 'subscript' ],
                [ 'fa fa-eraser' => 'eraser(remove, delete)' ],
                [ 'fa fa-file' => 'File(new, page, pdf, document)' ],
                [ 'fa fa-file-text' => 'File Text(new, page, pdf, document)' ],
                [ 'fa fa-header' => 'header(heading)' ],
                [ 'fa fa-paragraph' => 'paragraph' ],
            ],
            'Spinner Icons'         => [
                [ 'fa fa-cog' => 'cog(settings)(gear)' ],
                [ 'fa fa-refresh' => 'refresh(reload, sync)' ],
                [ 'fa fa-spinner' => 'Spinner(loading, progress)' ],
                [ 'fa fa-circle-o-notch' => 'Circle Outlined Notched' ],
            ],
            'File Type Icons'       => [
                [ 'fa fa-file-o' => 'File Outlined(new, page, pdf, document)' ],
                [ 'fa fa-file-text-o' => 'File Text Outlined(new, page, pdf, document)' ],
                [ 'fa fa-file' => 'File(new, page, pdf, document)' ],
                [ 'fa fa-file-text' => 'File Text(new, page, pdf, document)' ],
                [ 'fa fa-file-pdf-o' => 'PDF File Outlined' ],
                [ 'fa fa-file-word-o' => 'Word File Outlined' ],
                [ 'fa fa-file-excel-o' => 'Excel File Outlined' ],
                [ 'fa fa-file-powerpoint-o' => 'Powerpoint File Outlined' ],
                [ 'fa fa-file-image-o' => 'Image File Outlined(file-photo-o, file-picture-o)' ],
                [ 'fa fa-file-archive-o' => 'Archive File Outlined(file-zip-o)' ],
                [ 'fa fa-file-audio-o' => 'Audio File Outlined(file-sound-o)' ],
                [ 'fa fa-file-video-o' => 'Video File Outlined(file-movie-o)' ],
                [ 'fa fa-file-code-o' => 'Code File Outlined' ],
            ],
            'Directional Icons'     => [
                [ 'fa fa-arrow-circle-o-down' => 'Arrow Circle Outlined Down(download)' ],
                [ 'fa fa-arrow-circle-o-up' => 'Arrow Circle Outlined Up' ],
                [ 'fa fa-arrows' => 'Arrows(move, reorder, resize)' ],
                [ 'fa fa-chevron-left' => 'chevron-left(bracket, previous, back)' ],
                [ 'fa fa-chevron-right' => 'chevron-right(bracket, next, forward)' ],
                [ 'fa fa-arrow-left' => 'arrow-left(previous, back)' ],
                [ 'fa fa-arrow-right' => 'arrow-right(next, forward)' ],
                [ 'fa fa-arrow-up' => 'arrow-up' ],
                [ 'fa fa-arrow-down' => 'arrow-down(download)' ],
                [ 'fa fa-chevron-up' => 'chevron-up' ],
                [ 'fa fa-chevron-down' => 'chevron-down' ],
                [ 'fa fa-arrows-v' => 'Arrows Vertical(resize)' ],
                [ 'fa fa-arrows-h' => 'Arrows Horizontal(resize)' ],
                [ 'fa fa-hand-o-right' => 'Hand Outlined Right(point, right, next, forward, finger)' ],
                [ 'fa fa-hand-o-left' => 'Hand Outlined Left(point, left, previous, back, finger)' ],
                [ 'fa fa-hand-o-up' => 'Hand Outlined Up(point, finger)' ],
                [ 'fa fa-hand-o-down' => 'Hand Outlined Down(point, finger)' ],
                [ 'fa fa-arrow-circle-left' => 'Arrow Circle Left(previous, back)' ],
                [ 'fa fa-arrow-circle-right' => 'Arrow Circle Right(next, forward)' ],
                [ 'fa fa-arrow-circle-up' => 'Arrow Circle Up' ],
                [ 'fa fa-arrow-circle-down' => 'Arrow Circle Down(download)' ],
                [ 'fa fa-arrows-alt' => 'Arrows Alt(expand, enlarge, fullscreen, bigger, move, reorder, resize, arrow)' ],
                [ 'fa fa-caret-down' => 'Caret Down(more, dropdown, menu, triangle down, arrow)' ],
                [ 'fa fa-caret-up' => 'Caret Up(triangle up, arrow)' ],
                [ 'fa fa-caret-left' => 'Caret Left(previous, back, triangle left, arrow)' ],
                [ 'fa fa-caret-right' => 'Caret Right(next, forward, triangle right, arrow)' ],
                [ 'fa fa-exchange' => 'Exchange(transfer, arrows, arrow)' ],
                [ 'fa fa-angle-double-left' => 'Angle Double Left(laquo, quote, previous, back, arrows)' ],
                [ 'fa fa-angle-double-right' => 'Angle Double Right(raquo, quote, next, forward, arrows)' ],
                [ 'fa fa-angle-double-up' => 'Angle Double Up(arrows)' ],
                [ 'fa fa-angle-double-down' => 'Angle Double Down(arrows)' ],
                [ 'fa fa-angle-left' => 'angle-left(previous, back, arrow)' ],
                [ 'fa fa-angle-right' => 'angle-right(next, forward, arrow)' ],
                [ 'fa fa-angle-up' => 'angle-up(arrow)' ],
                [ 'fa fa-angle-down' => 'angle-down(arrow)' ],
                [ 'fa fa-chevron-circle-left' => 'Chevron Circle Left(previous, back, arrow)' ],
                [ 'fa fa-chevron-circle-right' => 'Chevron Circle Right(next, forward, arrow)' ],
                [ 'fa fa-chevron-circle-up' => 'Chevron Circle Up(arrow)' ],
                [ 'fa fa-chevron-circle-down' => 'Chevron Circle Down(more, dropdown, menu, arrow)' ],
                [ 'fa fa-caret-square-o-down' => 'Caret Square Outlined Down(more, dropdown, menu)(toggle-down)' ],
                [ 'fa fa-caret-square-o-up' => 'Caret Square Outlined Up(toggle-up)' ],
                [ 'fa fa-caret-square-o-right' => 'Caret Square Outlined Right(next, forward)(toggle-right)' ],
                [ 'fa fa-long-arrow-down' => 'Long Arrow Down' ],
                [ 'fa fa-long-arrow-up' => 'Long Arrow Up' ],
                [ 'fa fa-long-arrow-left' => 'Long Arrow Left(previous, back)' ],
                [ 'fa fa-long-arrow-right' => 'Long Arrow Right' ],
                [ 'fa fa-arrow-circle-o-right' => 'Arrow Circle Outlined Right(next, forward)' ],
                [ 'fa fa-arrow-circle-o-left' => 'Arrow Circle Outlined Left(previous, back)' ],
                [ 'fa fa-caret-square-o-left' => 'Caret Square Outlined Left(previous, back)(toggle-left)' ],
            ],
            'Video Player Icons'    => [
                [ 'fa fa-play-circle-o' => 'Play Circle Outlined' ],
                [ 'fa fa-step-backward' => 'step-backward(rewind, previous, beginning, start, first)' ],
                [ 'fa fa-fast-backward' => 'fast-backward(rewind, previous, beginning, start, first)' ],
                [ 'fa fa-backward' => 'backward(rewind, previous)' ],
                [ 'fa fa-play' => 'play(start, playing, music, sound)' ],
                [ 'fa fa-pause' => 'pause(wait)' ],
                [ 'fa fa-stop' => 'stop(block, box, square)' ],
                [ 'fa fa-forward' => 'forward(forward, next)' ],
                [ 'fa fa-fast-forward' => 'fast-forward(next, end, last)' ],
                [ 'fa fa-step-forward' => 'step-forward(next, end, last)' ],
                [ 'fa fa-eject' => 'eject' ],
                [ 'fa fa-expand' => 'Expand(enlarge, bigger, resize)' ],
                [ 'fa fa-compress' => 'Compress(collapse, combine, contract, merge, smaller)' ],
                [ 'fa fa-random' => 'random(sort, shuffle)' ],
                [ 'fa fa-arrows-alt' => 'Arrows Alt(expand, enlarge, fullscreen, bigger, move, reorder, resize, arrow)' ],
                [ 'fa fa-play-circle' => 'Play Circle(start, playing)' ],
                [ 'fa fa-youtube-play' => 'YouTube Play(start, playing)' ],
                [ 'fa fa-pause-circle' => 'Pause Circle' ],
                [ 'fa fa-pause-circle-o' => 'Pause Circle Outlined' ],
                [ 'fa fa-stop-circle' => 'Stop Circle' ],
                [ 'fa fa-stop-circle-o' => 'Stop Circle Outlined' ],
            ],
            'Form Control Icons'    => [
                [ 'fa fa-check-square-o' => 'Check Square Outlined(todo, done, agree, accept, confirm, ok)' ],
                [ 'fa fa-square-o' => 'Square Outlined(block, square, box)' ],
                [ 'fa fa-square' => 'Square(block, box)' ],
                [ 'fa fa-plus-square' => 'Plus Square(add, new, create, expand)' ],
                [ 'fa fa-circle-o' => 'Circle Outlined' ],
                [ 'fa fa-circle' => 'Circle(dot, notification)' ],
                [ 'fa fa-minus-square' => 'Minus Square(hide, minify, delete, remove, trash, hide, collapse)' ],
                [ 'fa fa-minus-square-o' => 'Minus Square Outlined(hide, minify, delete, remove, trash, hide, collapse)' ],
                [ 'fa fa-check-square' => 'Check Square(checkmark, done, todo, agree, accept, confirm, ok)' ],
                [ 'fa fa-dot-circle-o' => 'Dot Circle Outlined(target, bullseye, notification)' ],
                [ 'fa fa-plus-square-o' => 'Plus Square Outlined(add, new, create, expand)' ],
            ],
            'Transportation Icons'  => [
                [ 'fa fa-plane' => 'plane(travel, trip, location, destination, airplane, fly, mode)' ],
                [ 'fa fa-truck' => 'truck(shipping)' ],
                [ 'fa fa-ambulance' => 'ambulance(vehicle, support, help)' ],
                [ 'fa fa-fighter-jet' => 'fighter-jet(fly, plane, airplane, quick, fast, travel)' ],
                [ 'fa fa-rocket' => 'rocket(app)' ],
                [ 'fa fa-wheelchair' => 'Wheelchair(handicap, person, accessibility, accessibile)' ],
                [ 'fa fa-space-shuttle' => 'Space Shuttle' ],
                [ 'fa fa-car' => 'Car(vehicle)(automobile)' ],
                [ 'fa fa-taxi' => 'Taxi(vehicle)(cab)' ],
                [ 'fa fa-bicycle' => 'Bicycle(vehicle, bike)' ],
                [ 'fa fa-bus' => 'Bus(vehicle)' ],
                [ 'fa fa-ship' => 'Ship(boat, sea)' ],
                [ 'fa fa-motorcycle' => 'Motorcycle(vehicle, bike)' ],
                [ 'fa fa-train' => 'Train' ],
                [ 'fa fa-subway' => 'Subway' ],
            ],
            'Chart Icons'           => [
                [ 'fa fa-bar-chart' => 'Bar Chart(graph, analytics)(bar-chart-o)' ],
                [ 'fa fa-area-chart' => 'Area Chart(graph, analytics)' ],
                [ 'fa fa-pie-chart' => 'Pie Chart(graph, analytics)' ],
                [ 'fa fa-line-chart' => 'Line Chart(graph, analytics)' ],
            ],
            'Brand Icons'           => [
                [ 'fa fa-twitter-square' => 'Twitter Square(tweet, social network)' ],
                [ 'fa fa-facebook-square' => 'Facebook Square(social network)' ],
                [ 'fa fa-linkedin-square' => 'LinkedIn Square' ],
                [ 'fa fa-github-square' => 'GitHub Square(octocat)' ],
                [ 'fa fa-twitter' => 'Twitter(tweet, social network)' ],
                [ 'fa fa-facebook' => 'Facebook(social network)(facebook-f)' ],
                [ 'fa fa-github' => 'GitHub(octocat)' ],
                [ 'fa fa-pinterest' => 'Pinterest' ],
                [ 'fa fa-pinterest-square' => 'Pinterest Square' ],
                [ 'fa fa-google-plus-square' => 'Google Plus Square(social network)' ],
                [ 'fa fa-google-plus' => 'Google Plus(social network)' ],
                [ 'fa fa-linkedin' => 'LinkedIn' ],
                [ 'fa fa-github-alt' => 'GitHub Alt(octocat)' ],
                [ 'fa fa-maxcdn' => 'MaxCDN' ],
                [ 'fa fa-html5' => 'HTML 5 Logo' ],
                [ 'fa fa-css3' => 'CSS 3 Logo(code)' ],
                [ 'fa fa-btc' => 'Bitcoin (BTC)(bitcoin)' ],
                [ 'fa fa-youtube-square' => 'YouTube Square(video, film)' ],
                [ 'fa fa-youtube' => 'YouTube(video, film)' ],
                [ 'fa fa-xing' => 'Xing' ],
                [ 'fa fa-xing-square' => 'Xing Square' ],
                [ 'fa fa-youtube-play' => 'YouTube Play(start, playing)' ],
                [ 'fa fa-dropbox' => 'Dropbox' ],
                [ 'fa fa-stack-overflow' => 'Stack Overflow' ],
                [ 'fa fa-instagram' => 'Instagram' ],
                [ 'fa fa-flickr' => 'Flickr' ],
                [ 'fa fa-adn' => 'App.net' ],
                [ 'fa fa-bitbucket' => 'Bitbucket(git)' ],
                [ 'fa fa-bitbucket-square' => 'Bitbucket Square(git)' ],
                [ 'fa fa-tumblr' => 'Tumblr' ],
                [ 'fa fa-tumblr-square' => 'Tumblr Square' ],
                [ 'fa fa-apple' => 'Apple(osx, food)' ],
                [ 'fa fa-windows' => 'Windows(microsoft)' ],
                [ 'fa fa-android' => 'Android(robot)' ],
                [ 'fa fa-linux' => 'Linux(tux)' ],
                [ 'fa fa-dribbble' => 'Dribbble' ],
                [ 'fa fa-skype' => 'Skype' ],
                [ 'fa fa-foursquare' => 'Foursquare' ],
                [ 'fa fa-trello' => 'Trello' ],
                [ 'fa fa-gratipay' => 'Gratipay (Gittip)(heart, like, favorite, love)(gittip)' ],
                [ 'fa fa-vk' => 'VK' ],
                [ 'fa fa-weibo' => 'Weibo' ],
                [ 'fa fa-renren' => 'Renren' ],
                [ 'fa fa-pagelines' => 'Pagelines(leaf, leaves, tree, plant, eco, nature)' ],
                [ 'fa fa-stack-exchange' => 'Stack Exchange' ],
                [ 'fa fa-vimeo-square' => 'Vimeo Square' ],
                [ 'fa fa-slack' => 'Slack Logo(hashtag, anchor, hash)' ],
                [ 'fa fa-wordpress' => 'WordPress Logo' ],
                [ 'fa fa-openid' => 'OpenID' ],
                [ 'fa fa-yahoo' => 'Yahoo Logo' ],
                [ 'fa fa-google' => 'Google Logo' ],
                [ 'fa fa-reddit' => 'reddit Logo' ],
                [ 'fa fa-reddit-square' => 'reddit Square' ],
                [ 'fa fa-stumbleupon-circle' => 'StumbleUpon Circle' ],
                [ 'fa fa-stumbleupon' => 'StumbleUpon Logo' ],
                [ 'fa fa-delicious' => 'Delicious Logo' ],
                [ 'fa fa-digg' => 'Digg Logo' ],
                [ 'fa fa-pied-piper-pp' => 'Pied Piper PP Logo (Old)' ],
                [ 'fa fa-pied-piper-alt' => 'Pied Piper Alternate Logo' ],
                [ 'fa fa-drupal' => 'Drupal Logo' ],
                [ 'fa fa-joomla' => 'Joomla Logo' ],
                [ 'fa fa-behance' => 'Behance' ],
                [ 'fa fa-behance-square' => 'Behance Square' ],
                [ 'fa fa-steam' => 'Steam' ],
                [ 'fa fa-steam-square' => 'Steam Square' ],
                [ 'fa fa-spotify' => 'Spotify' ],
                [ 'fa fa-deviantart' => 'deviantART' ],
                [ 'fa fa-soundcloud' => 'SoundCloud' ],
                [ 'fa fa-vine' => 'Vine' ],
                [ 'fa fa-codepen' => 'Codepen' ],
                [ 'fa fa-jsfiddle' => 'jsFiddle' ],
                [ 'fa fa-rebel' => 'Rebel Alliance(ra, resistance)' ],
                [ 'fa fa-empire' => 'Galactic Empire(ge)' ],
                [ 'fa fa-git-square' => 'Git Square' ],
                [ 'fa fa-git' => 'Git' ],
                [ 'fa fa-hacker-news' => 'Hacker News(y-combinator-square, yc-square)' ],
                [ 'fa fa-tencent-weibo' => 'Tencent Weibo' ],
                [ 'fa fa-qq' => 'QQ' ],
                [ 'fa fa-weixin' => 'Weixin (WeChat)(wechat)' ],
                [ 'fa fa-share-alt' => 'Share Alt' ],
                [ 'fa fa-share-alt-square' => 'Share Alt Square' ],
                [ 'fa fa-slideshare' => 'Slideshare' ],
                [ 'fa fa-twitch' => 'Twitch' ],
                [ 'fa fa-yelp' => 'Yelp' ],
                [ 'fa fa-paypal' => 'Paypal' ],
                [ 'fa fa-google-wallet' => 'Google Wallet' ],
                [ 'fa fa-cc-visa' => 'Visa Credit Card' ],
                [ 'fa fa-cc-mastercard' => 'MasterCard Credit Card' ],
                [ 'fa fa-cc-discover' => 'Discover Credit Card' ],
                [ 'fa fa-cc-amex' => 'American Express Credit Card(amex)' ],
                [ 'fa fa-cc-paypal' => 'Paypal Credit Card' ],
                [ 'fa fa-cc-stripe' => 'Stripe Credit Card' ],
                [ 'fa fa-lastfm' => 'last.fm' ],
                [ 'fa fa-lastfm-square' => 'last.fm Square' ],
                [ 'fa fa-ioxhost' => 'ioxhost' ],
                [ 'fa fa-angellist' => 'AngelList' ],
                [ 'fa fa-meanpath' => 'meanpath' ],
                [ 'fa fa-buysellads' => 'BuySellAds' ],
                [ 'fa fa-connectdevelop' => 'Connect Develop' ],
                [ 'fa fa-dashcube' => 'DashCube' ],
                [ 'fa fa-forumbee' => 'Forumbee' ],
                [ 'fa fa-leanpub' => 'Leanpub' ],
                [ 'fa fa-sellsy' => 'Sellsy' ],
                [ 'fa fa-shirtsinbulk' => 'Shirts in Bulk' ],
                [ 'fa fa-simplybuilt' => 'SimplyBuilt' ],
                [ 'fa fa-skyatlas' => 'skyatlas' ],
                [ 'fa fa-facebook-official' => 'Facebook Official' ],
                [ 'fa fa-pinterest-p' => 'Pinterest P' ],
                [ 'fa fa-whatsapp' => 'What\'s App' ],
                [ 'fa fa-viacoin' => 'Viacoin' ],
                [ 'fa fa-medium' => 'Medium' ],
                [ 'fa fa-y-combinator' => 'Y Combinator(yc)' ],
                [ 'fa fa-optin-monster' => 'Optin Monster' ],
                [ 'fa fa-opencart' => 'OpenCart' ],
                [ 'fa fa-expeditedssl' => 'ExpeditedSSL' ],
                [ 'fa fa-cc-jcb' => 'JCB Credit Card' ],
                [ 'fa fa-cc-diners-club' => 'Diner\'s Club Credit Card' ],
                [ 'fa fa-gg' => 'GG Currency' ],
                [ 'fa fa-gg-circle' => 'GG Currency Circle' ],
                [ 'fa fa-tripadvisor' => 'TripAdvisor' ],
                [ 'fa fa-odnoklassniki' => 'Odnoklassniki' ],
                [ 'fa fa-odnoklassniki-square' => 'Odnoklassniki Square' ],
                [ 'fa fa-get-pocket' => 'Get Pocket' ],
                [ 'fa fa-wikipedia-w' => 'Wikipedia W' ],
                [ 'fa fa-safari' => 'Safari(browser)' ],
                [ 'fa fa-chrome' => 'Chrome(browser)' ],
                [ 'fa fa-firefox' => 'Firefox(browser)' ],
                [ 'fa fa-opera' => 'Opera' ],
                [ 'fa fa-internet-explorer' => 'Internet-explorer(browser, ie)' ],
                [ 'fa fa-contao' => 'Contao' ],
                [ 'fa fa-500px' => '500px' ],
                [ 'fa fa-amazon' => 'Amazon' ],
                [ 'fa fa-houzz' => 'Houzz' ],
                [ 'fa fa-vimeo' => 'Vimeo' ],
                [ 'fa fa-black-tie' => 'Font Awesome Black Tie' ],
                [ 'fa fa-fonticons' => 'Fonticons' ],
                [ 'fa fa-reddit-alien' => 'reddit Alien' ],
                [ 'fa fa-edge' => 'Edge Browser(browser, ie)' ],
                [ 'fa fa-codiepie' => 'Codie Pie' ],
                [ 'fa fa-modx' => 'MODX' ],
                [ 'fa fa-fort-awesome' => 'Fort Awesome' ],
                [ 'fa fa-usb' => 'USB' ],
                [ 'fa fa-product-hunt' => 'Product Hunt' ],
                [ 'fa fa-mixcloud' => 'Mixcloud' ],
                [ 'fa fa-scribd' => 'Scribd' ],
                [ 'fa fa-bluetooth' => 'Bluetooth' ],
                [ 'fa fa-bluetooth-b' => 'Bluetooth' ],
                [ 'fa fa-gitlab' => 'GitLab' ],
                [ 'fa fa-wpbeginner' => 'WPBeginner' ],
                [ 'fa fa-wpforms' => 'WPForms' ],
                [ 'fa fa-envira' => 'Envira Gallery(leaf)' ],
                [ 'fa fa-glide' => 'Glide' ],
                [ 'fa fa-glide-g' => 'Glide G' ],
                [ 'fa fa-viadeo' => 'Viadeo' ],
                [ 'fa fa-viadeo-square' => 'Viadeo Square' ],
                [ 'fa fa-snapchat' => 'Snapchat' ],
                [ 'fa fa-snapchat-ghost' => 'Snapchat Ghost' ],
                [ 'fa fa-snapchat-square' => 'Snapchat Square' ],
                [ 'fa fa-pied-piper' => 'Pied Piper Logo' ],
                [ 'fa fa-first-order' => 'First Order' ],
                [ 'fa fa-yoast' => 'Yoast' ],
                [ 'fa fa-themeisle' => 'ThemeIsle' ],
                [ 'fa fa-google-plus-official' => 'Google Plus Official(google-plus-circle)' ],
                [ 'fa fa-font-awesome' => 'Font Awesome(fa)' ],
            ],
            'Hand Icons'            => [
                [ 'fa fa-thumbs-o-up' => 'Thumbs Up Outlined(like, approve, favorite, agree, hand)' ],
                [ 'fa fa-thumbs-o-down' => 'Thumbs Down Outlined(dislike, disapprove, disagree, hand)' ],
                [ 'fa fa-hand-o-right' => 'Hand Outlined Right(point, right, next, forward, finger)' ],
                [ 'fa fa-hand-o-left' => 'Hand Outlined Left(point, left, previous, back, finger)' ],
                [ 'fa fa-hand-o-up' => 'Hand Outlined Up(point, finger)' ],
                [ 'fa fa-hand-o-down' => 'Hand Outlined Down(point, finger)' ],
                [ 'fa fa-thumbs-up' => 'thumbs-up(like, favorite, approve, agree, hand)' ],
                [ 'fa fa-thumbs-down' => 'thumbs-down(dislike, disapprove, disagree, hand)' ],
                [ 'fa fa-hand-rock-o' => 'Rock (Hand)(hand-grab-o)' ],
                [ 'fa fa-hand-paper-o' => 'Paper (Hand)(stop)(hand-stop-o)' ],
                [ 'fa fa-hand-scissors-o' => 'Scissors (Hand)' ],
                [ 'fa fa-hand-lizard-o' => 'Lizard (Hand)' ],
                [ 'fa fa-hand-spock-o' => 'Spock (Hand)' ],
                [ 'fa fa-hand-pointer-o' => 'Hand Pointer' ],
                [ 'fa fa-hand-peace-o' => 'Hand Peace' ],
            ],
            'Payment Icons'         => [
                [ 'fa fa-credit-card' => 'credit-card(money, buy, debit, checkout, purchase, payment)' ],
                [ 'fa fa-paypal' => 'Paypal' ],
                [ 'fa fa-google-wallet' => 'Google Wallet' ],
                [ 'fa fa-cc-visa' => 'Visa Credit Card' ],
                [ 'fa fa-cc-mastercard' => 'MasterCard Credit Card' ],
                [ 'fa fa-cc-discover' => 'Discover Credit Card' ],
                [ 'fa fa-cc-amex' => 'American Express Credit Card(amex)' ],
                [ 'fa fa-cc-paypal' => 'Paypal Credit Card' ],
                [ 'fa fa-cc-stripe' => 'Stripe Credit Card' ],
                [ 'fa fa-cc-jcb' => 'JCB Credit Card' ],
                [ 'fa fa-cc-diners-club' => 'Diner\'s Club Credit Card' ],
                [ 'fa fa-credit-card-alt' => 'Credit Card(money, buy, debit, checkout, purchase, payment, credit card)' ],
            ],
            'Currency Icons'        => [
                [ 'fa fa-money' => 'Money(cash, money, buy, checkout, purchase, payment)' ],
                [ 'fa fa-eur' => 'Euro (EUR)(euro)' ],
                [ 'fa fa-gbp' => 'GBP' ],
                [ 'fa fa-usd' => 'US Dollar(dollar)' ],
                [ 'fa fa-inr' => 'Indian Rupee (INR)(rupee)' ],
                [ 'fa fa-jpy' => 'Japanese Yen (JPY)(cny, rmb, yen)' ],
                [ 'fa fa-rub' => 'Russian Ruble (RUB)(ruble, rouble)' ],
                [ 'fa fa-krw' => 'Korean Won (KRW)(won)' ],
                [ 'fa fa-btc' => 'Bitcoin (BTC)(bitcoin)' ],
                [ 'fa fa-try' => 'Turkish Lira (TRY)(turkish-lira)' ],
                [ 'fa fa-ils' => 'Shekel (ILS)(shekel, sheqel)' ],
                [ 'fa fa-gg' => 'GG Currency' ],
                [ 'fa fa-gg-circle' => 'GG Currency Circle' ],
            ],
            'Accessibility Icons'   => [
                [ 'fa fa-wheelchair' => 'Wheelchair(handicap, person, accessibility, accessibile)' ],
                [ 'fa fa-tty' => 'TTY' ],
                [ 'fa fa-cc' => 'Closed Captions' ],
                [ 'fa fa-universal-access' => 'Universal Access' ],
                [ 'fa fa-wheelchair-alt' => 'Wheelchair Alt' ],
                [ 'fa fa-question-circle-o' => 'Question Circle Outlined' ],
                [ 'fa fa-blind' => 'Blind' ],
                [ 'fa fa-audio-description' => 'Audio Description' ],
                [ 'fa fa-volume-control-phone' => 'Volume Control Phone' ],
                [ 'fa fa-braille' => 'Braille' ],
                [ 'fa fa-assistive-listening-systems' => 'Assistive Listening Systems' ],
                [ 'fa fa-american-sign-language-interpreting' => 'American Sign Language Interpreting(asl-interpreting)' ],
                [ 'fa fa-deaf' => 'Deaf(deafness, hard-of-hearing)' ],
                [ 'fa fa-sign-language' => 'Sign Language(signing)' ],
                [ 'fa fa-low-vision' => 'Low Vision' ],
            ],
            'Gender Icons'          => [
                [ 'fa fa-venus' => 'Venus(female)' ],
                [ 'fa fa-mars' => 'Mars(male)' ],
                [ 'fa fa-mercury' => 'Mercury(transgender)' ],
                [ 'fa fa-transgender' => 'Transgender(intersex)' ],
                [ 'fa fa-transgender-alt' => 'Transgender Alt' ],
                [ 'fa fa-venus-double' => 'Venus Double' ],
                [ 'fa fa-mars-double' => 'Mars Double' ],
                [ 'fa fa-venus-mars' => 'Venus Mars' ],
                [ 'fa fa-mars-stroke' => 'Mars Stroke' ],
                [ 'fa fa-mars-stroke-v' => 'Mars Stroke Vertical' ],
                [ 'fa fa-mars-stroke-h' => 'Mars Stroke Horizontal' ],
                [ 'fa fa-neuter' => 'Neuter' ],
                [ 'fa fa-genderless' => 'Genderless' ],
            ],
        ];

        $icons = apply_filters( "ct_mega_menu/get_icons", $icons );

        return $icons;
    }
}